/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import org.neo4j.time.SystemNanoClock;

public class CallTrackingClock
extends SystemNanoClock {
    private final SystemNanoClock actual;
    private volatile int nanosCalls;

    public CallTrackingClock(SystemNanoClock actual) {
        this.actual = actual;
    }

    public ZoneId getZone() {
        return this.actual.getZone();
    }

    public Clock withZone(ZoneId zone) {
        return this.actual.withZone(zone);
    }

    public Instant instant() {
        return this.actual.instant();
    }

    public long millis() {
        return this.actual.millis();
    }

    public long nanos() {
        try {
            long l = this.actual.nanos();
            return l;
        }
        finally {
            ++this.nanosCalls;
        }
    }

    public int callsToNanos() {
        return this.nanosCalls;
    }
}

