/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.store.format.BaseRecordFormats;
import org.neo4j.kernel.impl.store.format.Capability;
import org.neo4j.kernel.impl.store.format.CapabilityType;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.test.rule.RandomRule;

public class BaseRecordFormatsTest {
    private static final Capability[] CAPABILITIES = Capability.values();
    private static final CapabilityType[] CAPABILITY_TYPES = CapabilityType.values();
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldReportCompatibilityBetweenTwoEqualSetsOfCapabilities() {
        Capability[] capabilities = (Capability[])this.random.selection((Object[])CAPABILITIES, CAPABILITIES.length / 2, CAPABILITIES.length, false);
        this.assertCompatibility(capabilities, capabilities, true, CAPABILITY_TYPES);
    }

    @Test
    public void shouldReportCompatibilityForAdditiveAdditionalCapabilities() {
        Capability[] from = (Capability[])Iterators.array((Object[])new Capability[]{Capability.SCHEMA});
        Capability[] to = (Capability[])Iterators.array((Object[])new Capability[]{Capability.SCHEMA, Capability.POINT_PROPERTIES, Capability.TEMPORAL_PROPERTIES});
        this.assertCompatibility(from, to, true, CAPABILITY_TYPES);
    }

    @Test
    public void shouldReportIncompatibilityForChangingAdditionalCapabilities() {
        Capability[] from = (Capability[])Iterators.array((Object[])new Capability[]{Capability.SCHEMA});
        Capability[] to = (Capability[])Iterators.array((Object[])new Capability[]{Capability.SCHEMA, Capability.DENSE_NODES});
        this.assertCompatibility(from, to, false, CapabilityType.STORE);
    }

    @Test
    public void shouldReportIncompatibilityForAdditiveRemovedCapabilities() {
        Capability[] from = (Capability[])Iterators.array((Object[])new Capability[]{Capability.SCHEMA, Capability.POINT_PROPERTIES, Capability.TEMPORAL_PROPERTIES});
        Capability[] to = (Capability[])Iterators.array((Object[])new Capability[]{Capability.SCHEMA});
        this.assertCompatibility(from, to, false, CapabilityType.STORE);
    }

    private void assertCompatibility(Capability[] from, Capability[] to, boolean compatible, CapabilityType ... capabilityTypes) {
        for (CapabilityType type : capabilityTypes) {
            Assert.assertEquals((Object)compatible, (Object)this.format(from).hasCompatibleCapabilities(this.format(to), type));
        }
    }

    private RecordFormats format(Capability ... capabilities) {
        RecordFormats formats = (RecordFormats)Mockito.mock(BaseRecordFormats.class);
        Mockito.when((Object)formats.capabilities()).thenReturn((Object)capabilities);
        Mockito.when((Object)formats.hasCompatibleCapabilities((RecordFormats)ArgumentMatchers.any(RecordFormats.class), (CapabilityType)ArgumentMatchers.any(CapabilityType.class))).thenCallRealMethod();
        return formats;
    }
}

