/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.id.FreeIdKeeper;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class FreeIdKeeperTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void newlyConstructedInstanceShouldReportProperDefaultValues() throws Exception {
        FreeIdKeeper keeper = this.getFreeIdKeeperAggressive();
        Assert.assertEquals((long)-1L, (long)keeper.getId());
        Assert.assertEquals((long)0L, (long)keeper.getCount());
    }

    @Test
    public void freeingAnIdShouldReturnThatIdAndUpdateTheCountWhenAggressiveModeIsSet() throws Exception {
        FreeIdKeeper keeper = this.getFreeIdKeeperAggressive();
        keeper.freeId(13L);
        Assert.assertEquals((long)1L, (long)keeper.getCount());
        long result = keeper.getId();
        Assert.assertEquals((long)13L, (long)result);
        Assert.assertEquals((long)0L, (long)keeper.getCount());
    }

    @Test
    public void shouldReturnMinusOneWhenRunningOutOfIds() throws Exception {
        FreeIdKeeper keeper = this.getFreeIdKeeperAggressive();
        keeper.freeId(13L);
        Assert.assertEquals((long)13L, (long)keeper.getId());
        Assert.assertEquals((long)-1L, (long)keeper.getId());
        Assert.assertEquals((long)-1L, (long)keeper.getId());
    }

    @Test
    public void shouldOnlyOverflowWhenThresholdIsReached() throws Exception {
        StoreChannel channel = (StoreChannel)Mockito.spy((Object)((EphemeralFileSystemAbstraction)this.fs.get()).open(new File("id.file"), OpenMode.READ_WRITE));
        int batchSize = 10;
        FreeIdKeeper keeper = this.getFreeIdKeeperAggressive(channel, batchSize);
        Mockito.reset((Object[])new StoreChannel[]{channel});
        for (int i = 0; i < batchSize - 1; ++i) {
            keeper.freeId((long)i);
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{channel});
        keeper.freeId(10L);
        ((StoreChannel)Mockito.verify((Object)channel)).writeAll((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    @Test
    public void shouldReadBackPersistedIdsWhenAggressiveModeIsSet() throws Exception {
        int i;
        StoreChannel channel = this.getStoreChannel();
        int batchSize = 10;
        FreeIdKeeper keeper = this.getFreeIdKeeperAggressive(channel, batchSize);
        for (i = 0; i < batchSize; ++i) {
            keeper.freeId((long)i);
        }
        for (i = 0; i < batchSize; ++i) {
            Assert.assertEquals((long)i, (long)keeper.getId());
        }
    }

    @Test
    public void shouldReadBackManyPersistedIdBatchesWhenAggressiveModeIsSet() throws Exception {
        StoreChannel channel = this.getStoreChannel();
        int batchSize = 10;
        FreeIdKeeper keeper = this.getFreeIdKeeperAggressive(channel, batchSize);
        HashSet<Long> freeIds = new HashSet<Long>();
        for (long i = 0L; i < (long)(batchSize * 2); ++i) {
            keeper.freeId(i);
            freeIds.add(i);
        }
        Assert.assertEquals((long)freeIds.size(), (long)keeper.getCount());
        for (int i = batchSize * 2 - 1; i >= 0; --i) {
            Assert.assertTrue((boolean)freeIds.remove(keeper.getId()));
        }
    }

    @Test
    public void shouldFirstReturnNonPersistedIdsAndThenPersistedOnesWhenAggressiveMode() throws Exception {
        int i;
        StoreChannel channel = this.getStoreChannel();
        int batchSize = 10;
        FreeIdKeeper keeper = this.getFreeIdKeeperAggressive(channel, batchSize);
        for (int i2 = 0; i2 < batchSize; ++i2) {
            keeper.freeId((long)i2);
        }
        int extraIds = 3;
        for (i = batchSize; i < batchSize + extraIds; ++i) {
            keeper.freeId((long)i);
        }
        for (i = batchSize; i < batchSize + extraIds; ++i) {
            Assert.assertEquals((long)i, (long)keeper.getId());
        }
        for (i = 0; i < batchSize; ++i) {
            Assert.assertEquals((long)i, (long)keeper.getId());
        }
    }

    @Test
    public void persistedIdsShouldStillBeCounted() throws Exception {
        StoreChannel channel = this.getStoreChannel();
        int batchSize = 10;
        FreeIdKeeper keeper = new FreeIdKeeper(channel, batchSize, true);
        for (int i = 0; i < batchSize; ++i) {
            keeper.freeId((long)i);
        }
        int extraIds = 3;
        for (int i = batchSize; i < batchSize + extraIds; ++i) {
            keeper.freeId((long)i);
        }
        Assert.assertEquals((long)(batchSize + extraIds), (long)keeper.getCount());
    }

    @Test
    public void shouldStoreAndRestoreIds() throws Exception {
        StoreChannel channel = this.getStoreChannel();
        int batchSize = 10;
        FreeIdKeeper keeper = this.getFreeIdKeeperAggressive(channel, batchSize);
        HashSet<Long> freeIds = new HashSet<Long>();
        for (long i = 0L; i < (long)batchSize; ++i) {
            keeper.freeId(i);
            freeIds.add(i);
        }
        int extraIds = 3;
        for (long i = (long)batchSize; i < (long)(batchSize + extraIds); ++i) {
            keeper.freeId(i);
            freeIds.add(i);
        }
        keeper.close();
        channel.close();
        channel = ((EphemeralFileSystemAbstraction)this.fs.get()).open(new File("id.file"), OpenMode.READ_WRITE);
        keeper = this.getFreeIdKeeperAggressive(channel, batchSize);
        Assert.assertEquals((long)(batchSize + extraIds), (long)keeper.getCount());
        Assert.assertEquals((long)freeIds.size(), (long)keeper.getCount());
        for (int i = batchSize + extraIds - 1; i >= 0; --i) {
            long id = keeper.getId();
            Assert.assertTrue((boolean)freeIds.contains(id));
        }
    }

    @Test
    public void shouldNotReturnNewlyReleasedIdsIfAggressiveIsFalse() throws Exception {
        FreeIdKeeper keeper = this.getFreeIdKeeper();
        keeper.freeId(1L);
        long nextFree = keeper.getId();
        Assert.assertEquals((long)-1L, (long)nextFree);
    }

    @Test
    public void shouldNotReturnIdsPersistedDuringThisRunIfAggressiveIsFalse() throws Exception {
        StoreChannel channel = (StoreChannel)Mockito.spy((Object)((EphemeralFileSystemAbstraction)this.fs.get()).open(new File("id.file"), OpenMode.READ_WRITE));
        int batchSize = 10;
        FreeIdKeeper keeper = this.getFreeIdKeeper(channel, batchSize);
        for (int i = 0; i < batchSize; ++i) {
            keeper.freeId((long)i);
        }
        ((StoreChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
        Assert.assertEquals((long)-1L, (long)keeper.getId());
    }

    @Test
    public void shouldReturnIdsRestoredAndIgnoreNewlyReleasedIfAggressiveModeIsFalse() throws Exception {
        int i;
        StoreChannel channel = this.getStoreChannel();
        int batchSize = 10;
        FreeIdKeeper keeper = this.getFreeIdKeeper(channel, batchSize);
        HashSet<Long> freeIds = new HashSet<Long>();
        for (long i2 = 0L; i2 < (long)batchSize; ++i2) {
            keeper.freeId(i2);
            freeIds.add(i2);
        }
        keeper.close();
        channel.close();
        channel = ((EphemeralFileSystemAbstraction)this.fs.get()).open(new File("id.file"), OpenMode.READ_WRITE);
        keeper = this.getFreeIdKeeper(channel, batchSize);
        for (i = 0; i < batchSize; ++i) {
            keeper.freeId((long)i);
        }
        for (i = 0; i < batchSize; ++i) {
            Assert.assertTrue((boolean)freeIds.remove(keeper.getId()));
        }
        Assert.assertEquals((long)-1L, (long)keeper.getId());
    }

    @Test
    public void shouldReturnNoResultIfIdsAreRestoredAndExhaustedAndThereAreFreeIdsFromThisRunWithAggressiveFalse() throws Exception {
        int i;
        StoreChannel channel = this.getStoreChannel();
        int batchSize = 10;
        FreeIdKeeper keeper = this.getFreeIdKeeper(channel, batchSize);
        HashSet<Long> freeIds = new HashSet<Long>();
        for (long i2 = 0L; i2 < (long)batchSize; ++i2) {
            keeper.freeId(i2);
            freeIds.add(i2);
        }
        keeper.close();
        channel.close();
        channel = ((EphemeralFileSystemAbstraction)this.fs.get()).open(new File("id.file"), OpenMode.READ_WRITE);
        keeper = this.getFreeIdKeeper(channel, batchSize);
        for (i = 0; i < batchSize; ++i) {
            Assert.assertTrue((boolean)freeIds.remove(keeper.getId()));
        }
        for (i = 0; i < batchSize; ++i) {
            keeper.freeId((long)i);
        }
        Assert.assertEquals((long)-1L, (long)keeper.getId());
    }

    @Test
    public void shouldNotReturnReusedIdsAfterRestart() throws Exception {
        long id;
        StoreChannel channel = this.getStoreChannel();
        int batchSize = 10;
        FreeIdKeeper keeper = this.getFreeIdKeeperAggressive(channel, batchSize);
        long idGen = 0L;
        for (long i = 0L; i < (long)(batchSize * 4); ++i) {
            keeper.freeId(idGen++);
        }
        ArrayList<Long> reusedIds = new ArrayList<Long>();
        for (int i = 0; i < batchSize * 2; ++i) {
            id = keeper.getId();
            reusedIds.add(id);
        }
        keeper.close();
        channel.close();
        channel = this.getStoreChannel();
        keeper = this.getFreeIdKeeper(channel, batchSize);
        ArrayList<Long> remainingIds = new ArrayList<Long>();
        while ((id = keeper.getId()) != -1L) {
            remainingIds.add(id);
        }
        Assert.assertEquals((long)(2 * batchSize), (long)remainingIds.size());
        for (Long remainingId : remainingIds) {
            Assert.assertFalse((boolean)reusedIds.contains(remainingId));
        }
    }

    @Test
    public void shouldTruncateFileInAggressiveMode() throws Exception {
        StoreChannel channel = this.getStoreChannel();
        int batchSize = 10;
        FreeIdKeeper keeper = this.getFreeIdKeeperAggressive(channel, batchSize);
        for (long i = 0L; i < (long)(batchSize * 4); ++i) {
            keeper.freeId(i);
        }
        Assert.assertEquals((long)channel.size(), (long)(4 * batchSize * 8));
        for (int i = 0; i < batchSize * 2; ++i) {
            keeper.getId();
        }
        Assert.assertEquals((long)channel.size(), (long)(2 * batchSize * 8));
    }

    @Test
    public void shouldCompactFileOnCloseInRegularMode() throws Exception {
        long i;
        StoreChannel channel = this.getStoreChannel();
        int batchSize = 10;
        FreeIdKeeper keeper = this.getFreeIdKeeper(channel, batchSize);
        for (i = 0L; i < (long)(batchSize * 4); ++i) {
            keeper.freeId(i);
        }
        keeper.close();
        Assert.assertEquals((long)channel.size(), (long)(4 * batchSize * 8));
        channel.close();
        channel = this.getStoreChannel();
        keeper = this.getFreeIdKeeper(channel, batchSize);
        for (i = 0L; i < (long)(batchSize * 4); ++i) {
            keeper.freeId(i);
        }
        for (int i2 = 0; i2 < batchSize * 2; ++i2) {
            keeper.getId();
        }
        keeper.close();
        Assert.assertEquals((long)channel.size(), (long)(6 * batchSize * 8));
    }

    @Test
    public void allocateEmptyBatchWhenNoIdsAreAvailable() throws IOException {
        FreeIdKeeper freeIdKeeper = this.getFreeIdKeeperAggressive();
        long[] ids = freeIdKeeper.getIds(1024);
        Assert.assertSame((Object)PrimitiveLongCollections.EMPTY_LONG_ARRAY, (Object)ids);
        Assert.assertEquals((long)0L, (long)freeIdKeeper.getCount());
    }

    @Test
    public void allocateBatchWhenHaveMoreIdsInMemory() throws IOException {
        FreeIdKeeper freeIdKeeper = this.getFreeIdKeeperAggressive();
        for (long id = 1L; id < 7L; ++id) {
            freeIdKeeper.freeId(id);
        }
        long[] ids = freeIdKeeper.getIds(5);
        Assert.assertArrayEquals((long[])new long[]{1L, 2L, 3L, 4L, 5L}, (long[])ids);
        Assert.assertEquals((long)1L, (long)freeIdKeeper.getCount());
    }

    @Test
    public void allocateBatchWhenHaveLessIdsInMemory() throws IOException {
        FreeIdKeeper freeIdKeeper = this.getFreeIdKeeperAggressive();
        for (long id = 1L; id < 4L; ++id) {
            freeIdKeeper.freeId(id);
        }
        long[] ids = freeIdKeeper.getIds(5);
        Assert.assertArrayEquals((long[])new long[]{1L, 2L, 3L}, (long[])ids);
        Assert.assertEquals((long)0L, (long)freeIdKeeper.getCount());
    }

    @Test
    public void allocateBatchWhenHaveLessIdsInMemoryButHaveOnDiskMore() throws IOException {
        FreeIdKeeper freeIdKeeper = this.getFreeIdKeeperAggressive(4);
        for (long id = 1L; id < 11L; ++id) {
            freeIdKeeper.freeId(id);
        }
        long[] ids = freeIdKeeper.getIds(7);
        Assert.assertArrayEquals((long[])new long[]{9L, 10L, 5L, 6L, 7L, 8L, 1L}, (long[])ids);
        Assert.assertEquals((long)3L, (long)freeIdKeeper.getCount());
    }

    @Test
    public void allocateBatchWhenHaveLessIdsInMemoryAndOnDisk() throws IOException {
        FreeIdKeeper freeIdKeeper = this.getFreeIdKeeperAggressive(4);
        for (long id = 1L; id < 10L; ++id) {
            freeIdKeeper.freeId(id);
        }
        long[] ids = freeIdKeeper.getIds(15);
        Assert.assertArrayEquals((long[])new long[]{9L, 5L, 6L, 7L, 8L, 1L, 2L, 3L, 4L}, (long[])ids);
        Assert.assertEquals((long)0L, (long)freeIdKeeper.getCount());
    }

    private FreeIdKeeper getFreeIdKeeperAggressive() throws IOException {
        return this.getFreeIdKeeperAggressive(this.getStoreChannel(), 10);
    }

    private FreeIdKeeper getFreeIdKeeperAggressive(int batchSize) throws IOException {
        return this.getFreeIdKeeperAggressive(this.getStoreChannel(), batchSize);
    }

    private FreeIdKeeper getFreeIdKeeperAggressive(StoreChannel channel, int batchSize) throws IOException {
        return this.getFreeIdKeeper(channel, batchSize, true);
    }

    private FreeIdKeeper getFreeIdKeeper(StoreChannel channel, int batchSize) throws IOException {
        return this.getFreeIdKeeper(channel, batchSize, false);
    }

    private FreeIdKeeper getFreeIdKeeper() throws IOException {
        return this.getFreeIdKeeper(this.getStoreChannel(), 10);
    }

    private FreeIdKeeper getFreeIdKeeper(StoreChannel channel, int batchSize, boolean aggressiveMode) throws IOException {
        return new FreeIdKeeper(channel, batchSize, aggressiveMode);
    }

    private StoreChannel getStoreChannel() throws IOException {
        return ((EphemeralFileSystemAbstraction)this.fs.get()).open(new File("id.file"), OpenMode.READ_WRITE);
    }
}

