/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.storemigration.participant.SchemaIndexMigrator;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;

public class SchemaIndexMigratorTest {
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final ProgressReporter progressReporter = (ProgressReporter)Mockito.mock(ProgressReporter.class);
    private final IndexProvider indexProvider = (IndexProvider)Mockito.mock(IndexProvider.class);
    private final DatabaseLayout databaseLayout = DatabaseLayout.of((File)new File("store"), (String)"graph.db");
    private final DatabaseLayout migrationLayout = DatabaseLayout.of((File)new File("migrationDir"), (String)"graph.db");
    private final SchemaIndexMigrator migrator = new SchemaIndexMigrator(this.fs, this.indexProvider);

    @Test
    public void schemaAndLabelIndexesRemovedAfterSuccessfulMigration() throws IOException {
        IndexDirectoryStructure directoryStructure = (IndexDirectoryStructure)Mockito.mock(IndexDirectoryStructure.class);
        File indexProviderRootDirectory = this.databaseLayout.file("just-some-directory");
        Mockito.when((Object)directoryStructure.rootDirectory()).thenReturn((Object)indexProviderRootDirectory);
        Mockito.when((Object)this.indexProvider.directoryStructure()).thenReturn((Object)directoryStructure);
        Mockito.when((Object)this.indexProvider.getProviderDescriptor()).thenReturn((Object)new IndexProviderDescriptor("key", "version"));
        this.migrator.migrate(this.databaseLayout, this.migrationLayout, this.progressReporter, StandardV2_3.STORE_VERSION, StandardV3_0.STORE_VERSION);
        this.migrator.moveMigratedFiles(this.migrationLayout, this.databaseLayout, StandardV2_3.STORE_VERSION, StandardV3_0.STORE_VERSION);
        ((FileSystemAbstraction)Mockito.verify((Object)this.fs)).deleteRecursively(indexProviderRootDirectory);
    }
}

