/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingUpdateService;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.IndexActivator;
import org.neo4j.kernel.impl.transaction.command.IndexBatchTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.IndexUpdatesWork;
import org.neo4j.kernel.impl.transaction.command.LabelUpdateWork;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.util.concurrent.WorkSync;

public class NeoTransactionIndexApplierTest {
    private static final IndexProviderDescriptor INDEX_DESCRIPTOR = new IndexProviderDescriptor("in-memory", "1.0");
    private final IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
    private final Supplier<LabelScanWriter> labelScanStore = (Supplier)Mockito.mock(Supplier.class);
    private final Collection<DynamicRecord> emptyDynamicRecords = Collections.emptySet();
    private final WorkSync<Supplier<LabelScanWriter>, LabelUpdateWork> labelScanStoreSynchronizer = new WorkSync(this.labelScanStore);
    private final WorkSync<IndexingUpdateService, IndexUpdatesWork> indexUpdatesSync = new WorkSync((Object)this.indexingService);
    private final TransactionToApply transactionToApply = (TransactionToApply)Mockito.mock(TransactionToApply.class);

    @Before
    public void setup() {
        Mockito.when((Object)this.transactionToApply.transactionId()).thenReturn((Object)1L);
        Mockito.when((Object)this.indexingService.convertToIndexUpdates((EntityUpdates)ArgumentMatchers.any(), (EntityType)ArgumentMatchers.eq((Object)EntityType.NODE))).thenAnswer(o -> Iterables.empty());
    }

    @Test
    public void shouldUpdateLabelStoreScanOnNodeCommands() throws Exception {
        boolean result;
        IndexBatchTransactionApplier applier = this.newIndexTransactionApplier();
        NodeRecord before = new NodeRecord(11L);
        before.setLabelField(17L, this.emptyDynamicRecords);
        NodeRecord after = new NodeRecord(12L);
        after.setLabelField(18L, this.emptyDynamicRecords);
        Command.NodeCommand command = new Command.NodeCommand(before, after);
        LabelScanWriter labelScanWriter = (LabelScanWriter)Mockito.mock(LabelScanWriter.class);
        Mockito.when((Object)this.labelScanStore.get()).thenReturn((Object)labelScanWriter);
        try (TransactionApplier txApplier = applier.startTx((CommandsToApply)this.transactionToApply);){
            result = txApplier.visitNodeCommand(command);
        }
        Assert.assertFalse((boolean)result);
    }

    private IndexBatchTransactionApplier newIndexTransactionApplier() {
        PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
        return new IndexBatchTransactionApplier(this.indexingService, this.labelScanStoreSynchronizer, this.indexUpdatesSync, (NodeStore)Mockito.mock(NodeStore.class), (RelationshipStore)Mockito.mock(RelationshipStore.class), propertyStore, new IndexActivator(this.indexingService));
    }

    @Test
    public void shouldCreateIndexGivenCreateSchemaRuleCommand() throws Exception {
        boolean result;
        StoreIndexDescriptor indexRule = this.indexRule(1L, 42, 42, INDEX_DESCRIPTOR);
        IndexBatchTransactionApplier applier = this.newIndexTransactionApplier();
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(this.emptyDynamicRecords, Collections.singleton(NeoTransactionIndexApplierTest.createdDynamicRecord(1L)), (SchemaRule)indexRule);
        try (TransactionApplier txApplier = applier.startTx((CommandsToApply)this.transactionToApply);){
            result = txApplier.visitSchemaRuleCommand(command);
        }
        Assert.assertFalse((boolean)result);
        ((IndexingService)Mockito.verify((Object)this.indexingService)).createIndexes(new StoreIndexDescriptor[]{indexRule});
    }

    private StoreIndexDescriptor indexRule(long ruleId, int labelId, int propertyId, IndexProviderDescriptor descriptor) {
        return IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyId}), (IndexProviderDescriptor)descriptor).withId(ruleId);
    }

    @Test
    public void shouldDropIndexGivenDropSchemaRuleCommand() throws Exception {
        boolean result;
        StoreIndexDescriptor indexRule = this.indexRule(1L, 42, 42, INDEX_DESCRIPTOR);
        IndexBatchTransactionApplier applier = this.newIndexTransactionApplier();
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand(Collections.singleton(NeoTransactionIndexApplierTest.createdDynamicRecord(1L)), Collections.singleton(DynamicRecord.dynamicRecord((long)1L, (boolean)false)), (SchemaRule)indexRule);
        try (TransactionApplier txApplier = applier.startTx((CommandsToApply)this.transactionToApply);){
            result = txApplier.visitSchemaRuleCommand(command);
        }
        Assert.assertFalse((boolean)result);
        ((IndexingService)Mockito.verify((Object)this.indexingService)).dropIndex(indexRule);
    }

    private static DynamicRecord createdDynamicRecord(long id) {
        DynamicRecord record = DynamicRecord.dynamicRecord((long)id, (boolean)true);
        record.setCreated();
        return record;
    }
}

