/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.Commands;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV3_0;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV3_0_2;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class PhysicalLogCommandReaderV3_0Test {
    @Test
    public void shouldReadRelationshipCommand() throws Throwable {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        RelationshipRecord before = new RelationshipRecord(42L, -1L, -1L, -1);
        RelationshipRecord after = new RelationshipRecord(42L, true, 1L, 2L, 3, 4L, 5L, 6L, 7L, true, true);
        new Command.RelationshipCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0 reader = new PhysicalLogCommandReaderV3_0();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.RelationshipCommand));
        Command.RelationshipCommand relationshipCommand = (Command.RelationshipCommand)command;
        Assert.assertEquals((Object)before, (Object)relationshipCommand.getBefore());
        Assert.assertEquals((Object)after, (Object)relationshipCommand.getAfter());
    }

    @Test
    public void readRelationshipCommandWithSecondaryUnit() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        RelationshipRecord before = new RelationshipRecord(42L, true, 1L, 2L, 3, 4L, 5L, 6L, 7L, true, true);
        before.setRequiresSecondaryUnit(true);
        before.setSecondaryUnitId(47L);
        RelationshipRecord after = new RelationshipRecord(42L, true, 1L, 8L, 3, 4L, 5L, 6L, 7L, true, true);
        new Command.RelationshipCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0 reader = new PhysicalLogCommandReaderV3_0();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.RelationshipCommand));
        Command.RelationshipCommand relationshipCommand = (Command.RelationshipCommand)command;
        Assert.assertEquals((Object)before, (Object)relationshipCommand.getBefore());
        this.verifySecondaryUnit((AbstractBaseRecord)before, (AbstractBaseRecord)relationshipCommand.getBefore());
        Assert.assertEquals((Object)after, (Object)relationshipCommand.getAfter());
    }

    @Test
    public void readRelationshipCommandWithNonRequiredSecondaryUnit() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        RelationshipRecord before = new RelationshipRecord(42L, true, 1L, 2L, 3, 4L, 5L, 6L, 7L, true, true);
        before.setRequiresSecondaryUnit(false);
        before.setSecondaryUnitId(52L);
        RelationshipRecord after = new RelationshipRecord(42L, true, 1L, 8L, 3, 4L, 5L, 6L, 7L, true, true);
        new Command.RelationshipCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0 reader = new PhysicalLogCommandReaderV3_0();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.RelationshipCommand));
        Command.RelationshipCommand relationshipCommand = (Command.RelationshipCommand)command;
        Assert.assertEquals((Object)before, (Object)relationshipCommand.getBefore());
        this.verifySecondaryUnit((AbstractBaseRecord)before, (AbstractBaseRecord)relationshipCommand.getBefore());
        Assert.assertEquals((Object)after, (Object)relationshipCommand.getAfter());
    }

    @Test
    public void readRelationshipCommandWithFixedReferenceFormat300() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        RelationshipRecord before = new RelationshipRecord(42L, true, 1L, 2L, 3, 4L, 5L, 6L, 7L, true, true);
        before.setUseFixedReferences(true);
        RelationshipRecord after = new RelationshipRecord(42L, true, 1L, 8L, 3, 4L, 5L, 6L, 7L, true, true);
        after.setUseFixedReferences(true);
        new Command.RelationshipCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0 reader = new PhysicalLogCommandReaderV3_0();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.RelationshipCommand));
        Command.RelationshipCommand relationshipCommand = (Command.RelationshipCommand)command;
        Assert.assertEquals((Object)before, (Object)relationshipCommand.getBefore());
        Assert.assertTrue((boolean)((RelationshipRecord)relationshipCommand.getBefore()).isUseFixedReferences());
        Assert.assertEquals((Object)after, (Object)relationshipCommand.getAfter());
        Assert.assertTrue((boolean)((RelationshipRecord)relationshipCommand.getAfter()).isUseFixedReferences());
    }

    @Test
    public void readRelationshipCommandWithFixedReferenceFormat302() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        RelationshipRecord before = new RelationshipRecord(42L, true, 1L, 2L, 3, 4L, 5L, 6L, 7L, true, true);
        before.setUseFixedReferences(true);
        RelationshipRecord after = new RelationshipRecord(42L, true, 1L, 8L, 3, 4L, 5L, 6L, 7L, true, true);
        after.setUseFixedReferences(true);
        new Command.RelationshipCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0_2 reader = new PhysicalLogCommandReaderV3_0_2();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.RelationshipCommand));
        Command.RelationshipCommand relationshipCommand = (Command.RelationshipCommand)command;
        Assert.assertEquals((Object)before, (Object)relationshipCommand.getBefore());
        Assert.assertTrue((boolean)((RelationshipRecord)relationshipCommand.getBefore()).isUseFixedReferences());
        Assert.assertEquals((Object)after, (Object)relationshipCommand.getAfter());
        Assert.assertTrue((boolean)((RelationshipRecord)relationshipCommand.getAfter()).isUseFixedReferences());
    }

    @Test
    public void shouldReadRelationshipGroupCommand() throws Throwable {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        RelationshipGroupRecord before = new RelationshipGroupRecord(42L, 3);
        RelationshipGroupRecord after = new RelationshipGroupRecord(42L, 3, 4L, 5L, 6L, 7L, 8L, true);
        after.setCreated();
        new Command.RelationshipGroupCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0 reader = new PhysicalLogCommandReaderV3_0();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.RelationshipGroupCommand));
        Command.RelationshipGroupCommand relationshipGroupCommand = (Command.RelationshipGroupCommand)command;
        Assert.assertEquals((Object)before, (Object)relationshipGroupCommand.getBefore());
        Assert.assertEquals((Object)after, (Object)relationshipGroupCommand.getAfter());
    }

    @Test
    public void readRelationshipGroupCommandWithSecondaryUnit() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        RelationshipGroupRecord before = new RelationshipGroupRecord(42L, 3);
        RelationshipGroupRecord after = new RelationshipGroupRecord(42L, 3, 4L, 5L, 6L, 7L, 8L, true);
        after.setRequiresSecondaryUnit(true);
        after.setSecondaryUnitId(17L);
        after.setCreated();
        new Command.RelationshipGroupCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0 reader = new PhysicalLogCommandReaderV3_0();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.RelationshipGroupCommand));
        Command.RelationshipGroupCommand relationshipGroupCommand = (Command.RelationshipGroupCommand)command;
        Assert.assertEquals((Object)before, (Object)relationshipGroupCommand.getBefore());
        Assert.assertEquals((Object)after, (Object)relationshipGroupCommand.getAfter());
        this.verifySecondaryUnit((AbstractBaseRecord)after, (AbstractBaseRecord)relationshipGroupCommand.getAfter());
    }

    @Test
    public void readRelationshipGroupCommandWithNonRequiredSecondaryUnit() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        RelationshipGroupRecord before = new RelationshipGroupRecord(42L, 3);
        RelationshipGroupRecord after = new RelationshipGroupRecord(42L, 3, 4L, 5L, 6L, 7L, 8L, true);
        after.setRequiresSecondaryUnit(false);
        after.setSecondaryUnitId(17L);
        after.setCreated();
        new Command.RelationshipGroupCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0 reader = new PhysicalLogCommandReaderV3_0();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.RelationshipGroupCommand));
        Command.RelationshipGroupCommand relationshipGroupCommand = (Command.RelationshipGroupCommand)command;
        Assert.assertEquals((Object)before, (Object)relationshipGroupCommand.getBefore());
        Assert.assertEquals((Object)after, (Object)relationshipGroupCommand.getAfter());
        this.verifySecondaryUnit((AbstractBaseRecord)after, (AbstractBaseRecord)relationshipGroupCommand.getAfter());
    }

    @Test
    public void readRelationshipGroupCommandWithFixedReferenceFormat300() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        RelationshipGroupRecord before = new RelationshipGroupRecord(42L, 3);
        before.setUseFixedReferences(true);
        RelationshipGroupRecord after = new RelationshipGroupRecord(42L, 3, 4L, 5L, 6L, 7L, 8L, true);
        after.setUseFixedReferences(true);
        new Command.RelationshipGroupCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0 reader = new PhysicalLogCommandReaderV3_0();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.RelationshipGroupCommand));
        Command.RelationshipGroupCommand relationshipGroupCommand = (Command.RelationshipGroupCommand)command;
        Assert.assertEquals((Object)before, (Object)relationshipGroupCommand.getBefore());
        Assert.assertEquals((Object)after, (Object)relationshipGroupCommand.getAfter());
        Assert.assertTrue((boolean)((RelationshipGroupRecord)relationshipGroupCommand.getBefore()).isUseFixedReferences());
        Assert.assertTrue((boolean)((RelationshipGroupRecord)relationshipGroupCommand.getAfter()).isUseFixedReferences());
    }

    @Test
    public void readRelationshipGroupCommandWithFixedReferenceFormat302() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        RelationshipGroupRecord before = new RelationshipGroupRecord(42L, 3);
        before.setUseFixedReferences(true);
        RelationshipGroupRecord after = new RelationshipGroupRecord(42L, 3, 4L, 5L, 6L, 7L, 8L, true);
        after.setUseFixedReferences(true);
        new Command.RelationshipGroupCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0_2 reader = new PhysicalLogCommandReaderV3_0_2();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.RelationshipGroupCommand));
        Command.RelationshipGroupCommand relationshipGroupCommand = (Command.RelationshipGroupCommand)command;
        Assert.assertEquals((Object)before, (Object)relationshipGroupCommand.getBefore());
        Assert.assertEquals((Object)after, (Object)relationshipGroupCommand.getAfter());
        Assert.assertTrue((boolean)((RelationshipGroupRecord)relationshipGroupCommand.getBefore()).isUseFixedReferences());
        Assert.assertTrue((boolean)((RelationshipGroupRecord)relationshipGroupCommand.getAfter()).isUseFixedReferences());
    }

    @Test
    public void shouldReadNeoStoreCommand() throws Throwable {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        NeoStoreRecord before = new NeoStoreRecord();
        NeoStoreRecord after = new NeoStoreRecord();
        after.setNextProp(42L);
        new Command.NeoStoreCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0 reader = new PhysicalLogCommandReaderV3_0();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.NeoStoreCommand));
        Command.NeoStoreCommand neoStoreCommand = (Command.NeoStoreCommand)command;
        Assert.assertEquals((long)before.getNextProp(), (long)((NeoStoreRecord)neoStoreCommand.getBefore()).getNextProp());
        Assert.assertEquals((long)after.getNextProp(), (long)((NeoStoreRecord)neoStoreCommand.getAfter()).getNextProp());
    }

    @Test
    public void nodeCommandWithFixedReferenceFormat300() throws Exception {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        NodeRecord before = new NodeRecord(42L, true, false, 33L, 99L, 66L);
        NodeRecord after = new NodeRecord(42L, true, false, 33L, 99L, 66L);
        before.setUseFixedReferences(true);
        after.setUseFixedReferences(true);
        new Command.NodeCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0 reader = new PhysicalLogCommandReaderV3_0();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.NodeCommand));
        Command.NodeCommand nodeCommand = (Command.NodeCommand)command;
        Assert.assertEquals((Object)before, (Object)nodeCommand.getBefore());
        Assert.assertEquals((Object)after, (Object)nodeCommand.getAfter());
        Assert.assertTrue((boolean)((NodeRecord)nodeCommand.getBefore()).isUseFixedReferences());
        Assert.assertTrue((boolean)((NodeRecord)nodeCommand.getAfter()).isUseFixedReferences());
    }

    @Test
    public void nodeCommandWithFixedReferenceFormat302() throws Exception {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        NodeRecord before = new NodeRecord(42L, true, false, 33L, 99L, 66L);
        NodeRecord after = new NodeRecord(42L, true, false, 33L, 99L, 66L);
        before.setUseFixedReferences(true);
        after.setUseFixedReferences(true);
        new Command.NodeCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0_2 reader = new PhysicalLogCommandReaderV3_0_2();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.NodeCommand));
        Command.NodeCommand nodeCommand = (Command.NodeCommand)command;
        Assert.assertEquals((Object)before, (Object)nodeCommand.getBefore());
        Assert.assertEquals((Object)after, (Object)nodeCommand.getAfter());
        Assert.assertTrue((boolean)((NodeRecord)nodeCommand.getBefore()).isUseFixedReferences());
        Assert.assertTrue((boolean)((NodeRecord)nodeCommand.getAfter()).isUseFixedReferences());
    }

    @Test
    public void readPropertyCommandWithSecondaryUnit() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        PropertyRecord before = new PropertyRecord(1L);
        PropertyRecord after = new PropertyRecord(2L);
        after.setRequiresSecondaryUnit(true);
        after.setSecondaryUnitId(78L);
        new Command.PropertyCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0 reader = new PhysicalLogCommandReaderV3_0();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.PropertyCommand));
        Command.PropertyCommand neoStoreCommand = (Command.PropertyCommand)command;
        Assert.assertEquals((long)before.getNextProp(), (long)((PropertyRecord)neoStoreCommand.getBefore()).getNextProp());
        Assert.assertEquals((long)after.getNextProp(), (long)((PropertyRecord)neoStoreCommand.getAfter()).getNextProp());
        this.verifySecondaryUnit((AbstractBaseRecord)after, (AbstractBaseRecord)neoStoreCommand.getAfter());
    }

    @Test
    public void readPropertyCommandWithNonRequiredSecondaryUnit() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        PropertyRecord before = new PropertyRecord(1L);
        PropertyRecord after = new PropertyRecord(2L);
        after.setRequiresSecondaryUnit(false);
        after.setSecondaryUnitId(78L);
        new Command.PropertyCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0 reader = new PhysicalLogCommandReaderV3_0();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.PropertyCommand));
        Command.PropertyCommand neoStoreCommand = (Command.PropertyCommand)command;
        Assert.assertEquals((long)before.getNextProp(), (long)((PropertyRecord)neoStoreCommand.getBefore()).getNextProp());
        Assert.assertEquals((long)after.getNextProp(), (long)((PropertyRecord)neoStoreCommand.getAfter()).getNextProp());
        this.verifySecondaryUnit((AbstractBaseRecord)after, (AbstractBaseRecord)neoStoreCommand.getAfter());
    }

    @Test
    public void readPropertyCommandWithFixedReferenceFormat300() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        PropertyRecord before = new PropertyRecord(1L);
        PropertyRecord after = new PropertyRecord(2L);
        before.setUseFixedReferences(true);
        after.setUseFixedReferences(true);
        new Command.PropertyCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0 reader = new PhysicalLogCommandReaderV3_0();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.PropertyCommand));
        Command.PropertyCommand neoStoreCommand = (Command.PropertyCommand)command;
        Assert.assertEquals((long)before.getNextProp(), (long)((PropertyRecord)neoStoreCommand.getBefore()).getNextProp());
        Assert.assertEquals((long)after.getNextProp(), (long)((PropertyRecord)neoStoreCommand.getAfter()).getNextProp());
        Assert.assertTrue((boolean)((PropertyRecord)neoStoreCommand.getBefore()).isUseFixedReferences());
        Assert.assertTrue((boolean)((PropertyRecord)neoStoreCommand.getAfter()).isUseFixedReferences());
    }

    @Test
    public void readPropertyCommandWithFixedReferenceFormat302() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        PropertyRecord before = new PropertyRecord(1L);
        PropertyRecord after = new PropertyRecord(2L);
        before.setUseFixedReferences(true);
        after.setUseFixedReferences(true);
        new Command.PropertyCommand(before, after).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0_2 reader = new PhysicalLogCommandReaderV3_0_2();
        Command command = reader.read((ReadableChannel)channel);
        Assert.assertTrue((boolean)(command instanceof Command.PropertyCommand));
        Command.PropertyCommand neoStoreCommand = (Command.PropertyCommand)command;
        Assert.assertEquals((long)before.getNextProp(), (long)((PropertyRecord)neoStoreCommand.getBefore()).getNextProp());
        Assert.assertEquals((long)after.getNextProp(), (long)((PropertyRecord)neoStoreCommand.getAfter()).getNextProp());
        Assert.assertTrue((boolean)((PropertyRecord)neoStoreCommand.getBefore()).isUseFixedReferences());
        Assert.assertTrue((boolean)((PropertyRecord)neoStoreCommand.getAfter()).isUseFixedReferences());
    }

    @Test
    public void shouldReadSomeCommands() throws Exception {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        Commands.createNode(0L, new long[0]).serialize((WritableChannel)channel);
        Commands.createNode(1L, new long[0]).serialize((WritableChannel)channel);
        Commands.createRelationshipTypeToken(0, 0).serialize((WritableChannel)channel);
        Commands.createRelationship(0L, 0L, 1L, 0).serialize((WritableChannel)channel);
        Commands.createPropertyKeyToken(0, 0).serialize((WritableChannel)channel);
        Commands.createProperty(0L, PropertyType.SHORT_STRING, 0, new long[0]).serialize((WritableChannel)channel);
        PhysicalLogCommandReaderV3_0 reader = new PhysicalLogCommandReaderV3_0();
        Assert.assertTrue((boolean)(reader.read((ReadableChannel)channel) instanceof Command.NodeCommand));
        Assert.assertTrue((boolean)(reader.read((ReadableChannel)channel) instanceof Command.NodeCommand));
        Assert.assertTrue((boolean)(reader.read((ReadableChannel)channel) instanceof Command.RelationshipTypeTokenCommand));
        Assert.assertTrue((boolean)(reader.read((ReadableChannel)channel) instanceof Command.RelationshipCommand));
        Assert.assertTrue((boolean)(reader.read((ReadableChannel)channel) instanceof Command.PropertyKeyTokenCommand));
        Assert.assertTrue((boolean)(reader.read((ReadableChannel)channel) instanceof Command.PropertyCommand));
    }

    private <T extends AbstractBaseRecord> void verifySecondaryUnit(T record, T commandRecord) {
        Assert.assertEquals((String)"Secondary unit requirements should be the same", (Object)record.requiresSecondaryUnit(), (Object)commandRecord.requiresSecondaryUnit());
        Assert.assertEquals((String)"Secondary unit ids should be the same", (long)record.getSecondaryUnitId(), (long)commandRecord.getSecondaryUnitId());
    }
}

