/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotationImpl;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.kernel.impl.transaction.tracing.SerializeTransactionEvent;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.KernelEventHandlers;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class BatchingTransactionAppenderRotationIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystem = new DefaultFileSystemRule();
    @Rule
    public final LifeRule life = new LifeRule(true);
    private final SimpleLogVersionRepository logVersionRepository = new SimpleLogVersionRepository();
    private final SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
    private final Monitors monitors = new Monitors();

    @Test
    public void correctLastAppliedToPreviousLogTransactionInHeaderOnLogFileRotation() throws IOException {
        LogFiles logFiles = this.getLogFiles(this.logVersionRepository, this.transactionIdStore);
        this.life.add((Lifecycle)logFiles);
        DatabaseHealth databaseHealth = BatchingTransactionAppenderRotationIT.getDatabaseHealth();
        LogRotationImpl logRotation = new LogRotationImpl((LogRotation.Monitor)this.monitors.newMonitor(LogRotation.Monitor.class, new String[0]), logFiles, databaseHealth);
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache();
        SynchronizedArrayIdOrderingQueue idOrderingQueue = new SynchronizedArrayIdOrderingQueue();
        BatchingTransactionAppender transactionAppender = new BatchingTransactionAppender(logFiles, (LogRotation)logRotation, transactionMetadataCache, (TransactionIdStore)this.transactionIdStore, (IdOrderingQueue)idOrderingQueue, databaseHealth);
        this.life.add((Lifecycle)transactionAppender);
        RotationLogAppendEvent logAppendEvent = new RotationLogAppendEvent(logRotation);
        TransactionToApply transactionToApply = BatchingTransactionAppenderRotationIT.prepareTransaction();
        transactionAppender.append(transactionToApply, (LogAppendEvent)logAppendEvent);
        Assert.assertEquals((long)1L, (long)logFiles.getHighestLogVersion());
        File highestLogFile = logFiles.getHighestLogFile();
        LogHeader logHeader = LogHeaderReader.readLogHeader((FileSystemAbstraction)this.fileSystem, (File)highestLogFile);
        Assert.assertEquals((long)2L, (long)logHeader.lastCommittedTxId);
    }

    private static TransactionToApply prepareTransaction() {
        List<StorageCommand> commands = BatchingTransactionAppenderRotationIT.createCommands();
        PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(commands);
        transactionRepresentation.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, 0);
        return new TransactionToApply((TransactionRepresentation)transactionRepresentation);
    }

    private static List<StorageCommand> createCommands() {
        return Collections.singletonList(new Command.NodeCommand(new NodeRecord(1L), new NodeRecord(2L)));
    }

    private LogFiles getLogFiles(SimpleLogVersionRepository logVersionRepository, SimpleTransactionIdStore transactionIdStore) throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.testDirectory.databaseLayout(), (FileSystemAbstraction)this.fileSystem.get()).withLogVersionRepository((LogVersionRepository)logVersionRepository).withTransactionIdStore((TransactionIdStore)transactionIdStore).build();
    }

    private static DatabaseHealth getDatabaseHealth() {
        DatabasePanicEventGenerator databasePanicEventGenerator = new DatabasePanicEventGenerator(new KernelEventHandlers((Log)NullLog.getInstance()));
        return new DatabaseHealth(databasePanicEventGenerator, (Log)NullLog.getInstance());
    }

    private static class RotationLogAppendEvent
    implements LogAppendEvent {
        private final LogRotationImpl logRotation;

        RotationLogAppendEvent(LogRotationImpl logRotation) {
            this.logRotation = logRotation;
        }

        public LogForceWaitEvent beginLogForceWait() {
            return null;
        }

        public LogForceEvent beginLogForce() {
            return null;
        }

        public void close() {
        }

        public void setLogRotated(boolean logRotated) {
        }

        public LogRotateEvent beginLogRotate() {
            return null;
        }

        public SerializeTransactionEvent beginSerializeTransaction() {
            return () -> {
                try {
                    this.logRotation.rotateLogFile();
                }
                catch (IOException e) {
                    throw new RuntimeException("Should be able to rotate file", e);
                }
            };
        }
    }
}

