/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;

public class TransactionLogFileInformationTest {
    private LogFiles logFiles = (LogFiles)Mockito.mock(TransactionLogFiles.class);
    private LogHeaderCache logHeaderCache = (LogHeaderCache)Mockito.mock(LogHeaderCache.class);
    private TransactionLogFilesContext context = (TransactionLogFilesContext)Mockito.mock(TransactionLogFilesContext.class);

    @Test
    public void shouldReadAndCacheFirstCommittedTransactionIdForAGivenVersionWhenNotCached() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long expected = 5L;
        long version = 10L;
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn(null);
        Mockito.when((Object)this.logFiles.versionExists(version)).thenReturn((Object)true);
        Mockito.when((Object)this.logFiles.extractHeader(version)).thenReturn((Object)new LogHeader(-1, -1L, expected - 1L));
        long firstCommittedTxId = info.getFirstEntryId(version);
        Assert.assertEquals((long)expected, (long)firstCommittedTxId);
        ((LogHeaderCache)Mockito.verify((Object)this.logHeaderCache, (VerificationMode)Mockito.times((int)1))).putHeader(version, expected - 1L);
    }

    @Test
    public void shouldReadFirstCommittedTransactionIdForAGivenVersionWhenCached() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long expected = 5L;
        long version = 10L;
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn((Object)(expected - 1L));
        long firstCommittedTxId = info.getFirstEntryId(version);
        Assert.assertEquals((long)expected, (long)firstCommittedTxId);
    }

    @Test
    public void shouldReadAndCacheFirstCommittedTransactionIdWhenNotCached() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long expected = 5L;
        long version = 10L;
        Mockito.when((Object)this.logFiles.getHighestLogVersion()).thenReturn((Object)version);
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn(null);
        Mockito.when((Object)this.logFiles.versionExists(version)).thenReturn((Object)true);
        Mockito.when((Object)this.logFiles.extractHeader(version)).thenReturn((Object)new LogHeader(-1, -1L, expected - 1L));
        Mockito.when((Object)this.logFiles.hasAnyEntries(version)).thenReturn((Object)true);
        long firstCommittedTxId = info.getFirstExistingEntryId();
        Assert.assertEquals((long)expected, (long)firstCommittedTxId);
        ((LogHeaderCache)Mockito.verify((Object)this.logHeaderCache, (VerificationMode)Mockito.times((int)1))).putHeader(version, expected - 1L);
    }

    @Test
    public void shouldReadFirstCommittedTransactionIdWhenCached() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long expected = 5L;
        long version = 10L;
        Mockito.when((Object)this.logFiles.getHighestLogVersion()).thenReturn((Object)version);
        Mockito.when((Object)this.logFiles.versionExists(version)).thenReturn((Object)true);
        Mockito.when((Object)this.logHeaderCache.getLogHeader(version)).thenReturn((Object)(expected - 1L));
        Mockito.when((Object)this.logFiles.hasAnyEntries(version)).thenReturn((Object)true);
        long firstCommittedTxId = info.getFirstExistingEntryId();
        Assert.assertEquals((long)expected, (long)firstCommittedTxId);
    }

    @Test
    public void shouldReturnNothingWhenThereAreNoTransactions() throws Exception {
        TransactionLogFileInformation info = new TransactionLogFileInformation(this.logFiles, this.logHeaderCache, this.context);
        long version = 10L;
        Mockito.when((Object)this.logFiles.getHighestLogVersion()).thenReturn((Object)version);
        Mockito.when((Object)this.logFiles.hasAnyEntries(version)).thenReturn((Object)false);
        long firstCommittedTxId = info.getFirstExistingEntryId();
        Assert.assertEquals((long)-1L, (long)firstCommittedTxId);
    }
}

