/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class TransactionLogFilesTest {
    @Rule
    public final FileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final String filename = "filename";

    @Test
    public void shouldGetTheFileNameForAGivenVersion() throws IOException {
        LogFiles files = this.createLogFiles();
        int version = 12;
        File versionFileName = files.getLogFileForVersion(12L);
        DatabaseLayout databaseLayout = this.testDirectory.databaseLayout();
        File expected = databaseLayout.file(this.getVersionedLogFileName(12));
        Assert.assertEquals((Object)expected, (Object)versionFileName);
    }

    @Test
    public void shouldVisitEachLofFile() throws Throwable {
        LogFiles files = this.createLogFiles();
        DatabaseLayout databaseLayout = this.testDirectory.databaseLayout();
        this.fileSystemRule.create(databaseLayout.file(this.getVersionedLogFileName("1"))).close();
        this.fileSystemRule.create(databaseLayout.file(this.getVersionedLogFileName("some", "2"))).close();
        this.fileSystemRule.create(databaseLayout.file(this.getVersionedLogFileName("3"))).close();
        this.fileSystemRule.create(databaseLayout.file("filename")).close();
        ArrayList seenFiles = new ArrayList();
        ArrayList seenVersions = new ArrayList();
        files.accept((file, logVersion) -> {
            seenFiles.add(file);
            seenVersions.add(logVersion);
        });
        Assert.assertThat(seenFiles, (Matcher)Matchers.containsInAnyOrder((Object[])new File[]{databaseLayout.file(this.getVersionedLogFileName("filename", "1")), databaseLayout.file(this.getVersionedLogFileName("filename", "3"))}));
        Assert.assertThat(seenVersions, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{1L, 3L}));
        files.shutdown();
    }

    @Test
    public void shouldBeAbleToRetrieveTheHighestLogVersion() throws Throwable {
        LogFiles files = this.createLogFiles();
        DatabaseLayout databaseLayout = this.testDirectory.databaseLayout();
        this.fileSystemRule.create(databaseLayout.file(this.getVersionedLogFileName("1"))).close();
        this.fileSystemRule.create(databaseLayout.file(this.getVersionedLogFileName("some", "4"))).close();
        this.fileSystemRule.create(databaseLayout.file(this.getVersionedLogFileName("3"))).close();
        this.fileSystemRule.create(databaseLayout.file("filename")).close();
        long highestLogVersion = files.getHighestLogVersion();
        Assert.assertEquals((long)3L, (long)highestLogVersion);
        files.shutdown();
    }

    @Test
    public void shouldReturnANegativeValueIfThereAreNoLogFiles() throws Throwable {
        LogFiles files = this.createLogFiles();
        DatabaseLayout databaseLayout = this.testDirectory.databaseLayout();
        this.fileSystemRule.create(databaseLayout.file(this.getVersionedLogFileName("some", "4"))).close();
        this.fileSystemRule.create(databaseLayout.file("filename")).close();
        long highestLogVersion = files.getHighestLogVersion();
        Assert.assertEquals((long)-1L, (long)highestLogVersion);
        files.shutdown();
    }

    @Test
    public void shouldFindTheVersionBasedOnTheFilename() throws Throwable {
        LogFiles logFiles = this.createLogFiles();
        File file = new File("v....2");
        long logVersion = logFiles.getLogVersion(file);
        Assert.assertEquals((long)2L, (long)logVersion);
        logFiles.shutdown();
    }

    @Test
    public void shouldThrowIfThereIsNoVersionInTheFileName() throws IOException {
        LogFiles logFiles = this.createLogFiles();
        File file = new File("wrong");
        try {
            logFiles.getLogVersion(file);
            Assert.fail((String)"should have thrown");
        }
        catch (RuntimeException ex) {
            Assert.assertEquals((Object)("Invalid log file '" + file.getName() + "'"), (Object)ex.getMessage());
        }
    }

    @Test(expected=NumberFormatException.class)
    public void shouldThrowIfVersionIsNotANumber() throws IOException {
        LogFiles logFiles = this.createLogFiles();
        File file = new File(this.getVersionedLogFileName("aa", "A"));
        logFiles.getLogVersion(file);
    }

    @Test
    public void isLogFile() throws IOException {
        LogFiles logFiles = this.createLogFiles();
        Assert.assertFalse((boolean)logFiles.isLogFile(new File("aaa.tx.log")));
        Assert.assertTrue((boolean)logFiles.isLogFile(new File("filename.0")));
        Assert.assertTrue((boolean)logFiles.isLogFile(new File("filename.17")));
    }

    private LogFiles createLogFiles() throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.testDirectory.databaseLayout(), (FileSystemAbstraction)this.fileSystemRule).withLogFileName("filename").withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).build();
    }

    private String getVersionedLogFileName(int version) {
        return this.getVersionedLogFileName("filename", String.valueOf(version));
    }

    private String getVersionedLogFileName(String version) {
        return this.getVersionedLogFileName("filename", version);
    }

    private String getVersionedLogFileName(String filename, String version) {
        return filename + "." + version;
    }
}

