/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdConfigParser;

public class ThresholdConfigValueTest {
    @Test
    public void shouldParseCorrectly() {
        ThresholdConfigParser.ThresholdConfigValue value = ThresholdConfigParser.parse((String)"25 files");
        Assert.assertEquals((Object)"files", (Object)value.type);
        Assert.assertEquals((long)25L, (long)value.value);
        value = ThresholdConfigParser.parse((String)"4g size");
        Assert.assertEquals((Object)"size", (Object)value.type);
        Assert.assertEquals((long)0x100000000L, (long)value.value);
    }

    @Test
    public void shouldThrowExceptionOnUnknownType() {
        try {
            ThresholdConfigParser.parse((String)"more than one spaces is invalid");
            Assert.fail((String)"Should not parse unknown types");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnNoPruningForTrue() {
        ThresholdConfigParser.ThresholdConfigValue value = ThresholdConfigParser.parse((String)"true");
        Assert.assertSame((Object)ThresholdConfigParser.ThresholdConfigValue.NO_PRUNING, (Object)value);
    }

    @Test
    public void shouldReturnKeepOneEntryForFalse() {
        ThresholdConfigParser.ThresholdConfigValue value = ThresholdConfigParser.parse((String)"false");
        Assert.assertEquals((Object)"entries", (Object)value.type);
        Assert.assertEquals((long)1L, (long)value.value);
    }
}

