/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.stresstest;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Suppliers;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.stresstest.workload.Runner;
import org.neo4j.test.rule.TestDirectory;

public class TransactionAppenderStressTest {
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();

    @Test
    public void concurrentTransactionAppendingTest() throws Exception {
        int threads = 10;
        Callable<Long> runner = new Builder().with(Suppliers.untilTimeExpired((long)10L, (TimeUnit)TimeUnit.SECONDS)).withWorkingDirectory(this.directory.databaseLayout()).withNumThreads(threads).build();
        long appendedTxs = runner.call();
        Assert.assertEquals((long)new TransactionIdChecker(this.directory.databaseLayout().databaseDirectory()).parseAllTxLogs(), (long)appendedTxs);
    }

    public static class TransactionIdChecker {
        private final File workingDirectory;

        public TransactionIdChecker(File workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        public long parseAllTxLogs() throws IOException {
            long txId = 1L;
            try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
                 ReadableLogChannel channel = this.openLogFile((FileSystemAbstraction)fs, 0);){
                VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader();
                LogEntry logEntry = reader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
                while (logEntry != null) {
                    if (logEntry.getType() == 5) {
                        txId = ((LogEntryCommit)logEntry.as()).getTxId();
                    }
                    logEntry = reader.readLogEntry((ReadableClosablePositionAwareChannel)channel);
                }
            }
            return txId;
        }

        private ReadableLogChannel openLogFile(FileSystemAbstraction fs, int version) throws IOException {
            LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.workingDirectory, (FileSystemAbstraction)fs).build();
            PhysicalLogVersionedStoreChannel channel = logFiles.openForVersion((long)version);
            return new ReadAheadLogChannel((LogVersionedStoreChannel)channel, (LogVersionBridge)new ReaderLogVersionBridge(logFiles));
        }
    }

    public static class Builder {
        private BooleanSupplier condition;
        private DatabaseLayout databaseLayout;
        private int threads;

        public Builder with(BooleanSupplier condition) {
            this.condition = condition;
            return this;
        }

        public Builder withWorkingDirectory(DatabaseLayout databaseLayout) {
            this.databaseLayout = databaseLayout;
            return this;
        }

        public Builder withNumThreads(int threads) {
            this.threads = threads;
            return this;
        }

        public Callable<Long> build() {
            return new Runner(this.databaseLayout, this.condition, this.threads);
        }
    }
}

