/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.impl.util.Dependencies;

class DefaultIndexProviderMapTest {
    DefaultIndexProviderMapTest() {
    }

    @Test
    void shouldNotSupportMultipleProvidersWithSameDescriptor() {
        IndexProviderDescriptor descriptor = new IndexProviderDescriptor("provider", "1.2");
        IndexProvider provider1 = (IndexProvider)Mockito.mock(IndexProvider.class);
        Mockito.when((Object)provider1.getProviderDescriptor()).thenReturn((Object)descriptor);
        IndexProvider provider2 = (IndexProvider)Mockito.mock(IndexProvider.class);
        Mockito.when((Object)provider2.getProviderDescriptor()).thenReturn((Object)descriptor);
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)provider1);
        dependencies.satisfyDependency((Object)provider2);
        Assertions.assertThrows(IllegalArgumentException.class, () -> DefaultIndexProviderMapTest.createDefaultProviderMap(dependencies, descriptor).init());
    }

    @Test
    void shouldThrowOnLookupOnUnknownProvider() {
        IndexProvider provider = (IndexProvider)Mockito.mock(IndexProvider.class);
        IndexProviderDescriptor descriptor = new IndexProviderDescriptor("provider", "1.2");
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)descriptor);
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)provider);
        DefaultIndexProviderMap defaultIndexProviderMap = DefaultIndexProviderMapTest.createDefaultProviderMap(dependencies, descriptor);
        defaultIndexProviderMap.init();
        Assertions.assertThrows(IndexProviderNotFoundException.class, () -> defaultIndexProviderMap.lookup(new IndexProviderDescriptor("provider2", "1.2")));
    }

    private static DefaultIndexProviderMap createDefaultProviderMap(Dependencies dependencies, IndexProviderDescriptor descriptor) {
        return new DefaultIndexProviderMap((DependencyResolver)dependencies, Config.defaults((Setting)GraphDatabaseSettings.default_schema_provider, (String)descriptor.name()));
    }
}

