/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.kernel.impl.traversal.AbstractTraverserIterator;

public class AbstractTraverserIteratorTest {
    @Test
    public void shouldCloseResourceOnce() {
        AbstractTraverserIterator iter = new AbstractTraverserIterator(new AssertOneClose()){

            protected Path fetchNextOrNull() {
                return null;
            }

            public boolean isUniqueFirst(TraversalBranch branch) {
                return false;
            }

            public boolean isUnique(TraversalBranch branch) {
                return false;
            }

            public <STATE> Evaluation evaluate(TraversalBranch branch, BranchState<STATE> state) {
                return null;
            }
        };
        iter.close();
        iter.close();
    }

    private static class AssertOneClose
    implements Resource {
        boolean isClosed;

        private AssertOneClose() {
        }

        public void close() {
            MatcherAssert.assertThat((String)"resource is closed", (Object)this.isClosed, (Matcher)Matchers.equalTo((Object)false));
            this.isClosed = true;
        }
    }
}

