/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class CountingJobScheduler
implements JobScheduler {
    private final AtomicInteger counter;
    private final JobScheduler delegate;

    public CountingJobScheduler(AtomicInteger counter, JobScheduler delegate) {
        this.counter = counter;
        this.delegate = delegate;
    }

    public void setTopLevelGroupName(String name) {
        this.delegate.setTopLevelGroupName(name);
    }

    public Executor executor(Group group) {
        return this.delegate.executor(group);
    }

    public ThreadFactory threadFactory(Group group) {
        return this.delegate.threadFactory(group);
    }

    public ExecutorService workStealingExecutor(Group group, int parallelism) {
        return this.delegate.workStealingExecutor(group, parallelism);
    }

    public ExecutorService workStealingExecutorAsyncMode(Group group, int parallelism) {
        return this.delegate.workStealingExecutorAsyncMode(group, parallelism);
    }

    public JobHandle schedule(Group group, Runnable job) {
        this.counter.getAndIncrement();
        return this.delegate.schedule(group, job);
    }

    public JobHandle schedule(Group group, Runnable runnable, long initialDelay, TimeUnit timeUnit) {
        this.counter.getAndIncrement();
        return this.delegate.schedule(group, runnable, initialDelay, timeUnit);
    }

    public JobHandle scheduleRecurring(Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        this.counter.getAndIncrement();
        return this.delegate.scheduleRecurring(group, runnable, period, timeUnit);
    }

    public JobHandle scheduleRecurring(Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        this.counter.getAndIncrement();
        return this.delegate.scheduleRecurring(group, runnable, initialDelay, period, timeUnit);
    }

    public void init() throws Throwable {
        this.delegate.init();
    }

    public void start() throws Throwable {
        this.delegate.start();
    }

    public void stop() throws Throwable {
        this.delegate.stop();
    }

    public void shutdown() throws Throwable {
        this.delegate.shutdown();
    }

    public void close() {
        try {
            this.shutdown();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

