/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import java.util.Collections;
import org.neo4j.cursor.IOCursor;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;

public class IOCursorAsResourceIterable<T>
implements ResourceIterable<T> {
    private final IOCursor<T> cursor;

    public IOCursorAsResourceIterable(IOCursor<T> cursor) {
        this.cursor = cursor;
    }

    public ResourceIterator<T> iterator() {
        try {
            if (this.cursor.next()) {
                final Object first = this.cursor.get();
                return new ResourceIterator<T>(){
                    T instance;
                    {
                        this.instance = first;
                    }

                    public boolean hasNext() {
                        return this.instance != null;
                    }

                    public T next() {
                        try {
                            Object t = this.instance;
                            return t;
                        }
                        finally {
                            try {
                                if (IOCursorAsResourceIterable.this.cursor.next()) {
                                    this.instance = IOCursorAsResourceIterable.this.cursor.get();
                                } else {
                                    IOCursorAsResourceIterable.this.cursor.close();
                                    this.instance = null;
                                }
                            }
                            catch (IOException e) {
                                this.instance = null;
                            }
                        }
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    public void close() {
                        try {
                            IOCursorAsResourceIterable.this.cursor.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
            }
            this.cursor.close();
            return Iterators.asResourceIterator(Collections.emptyIterator());
        }
        catch (IOException e) {
            return Iterators.asResourceIterator(Collections.emptyIterator());
        }
    }
}

