/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;

public class TestCopyOnWriteHashMap {
    @Test
    public void keySetUnaffectedByChanges() {
        CopyOnWriteHashMap map = new CopyOnWriteHashMap();
        map.put(0, "0");
        map.put(1, "1");
        map.put(2, "2");
        Assert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)0));
        Assert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)1));
        Assert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)2));
        Iterator keys = map.keySet().iterator();
        map.remove(1);
        List keysBeforeDeletion = Iterators.asList(keys);
        Assert.assertThat((Object)keysBeforeDeletion, (Matcher)Matchers.contains((Object[])new Integer[]{0, 1, 2}));
    }

    @Test
    public void entrySetUnaffectedByChanges() {
        CopyOnWriteHashMap map = new CopyOnWriteHashMap();
        map.put(0, "0");
        map.put(1, "1");
        map.put(2, "2");
        Object[] allEntries = map.entrySet().toArray(new Map.Entry[0]);
        Assert.assertThat(map.entrySet(), (Matcher)Matchers.containsInAnyOrder((Object[])allEntries));
        Iterator entries = map.entrySet().iterator();
        map.remove(1);
        List entriesBeforeRemoval = Iterators.asList(entries);
        Assert.assertThat((Object)entriesBeforeRemoval, (Matcher)Matchers.containsInAnyOrder((Object[])allEntries));
    }

    @Test
    public void snapshotShouldKeepData() {
        CopyOnWriteHashMap map = new CopyOnWriteHashMap();
        map.put((Object)0, (Object)"0");
        Map snapshot = map.snapshot();
        Assert.assertThat(snapshot.get(0), (Matcher)Matchers.is((Object)"0"));
        Assert.assertThat((Object)map.remove((Object)0), (Matcher)Matchers.is((Object)"0"));
        Assert.assertThat(snapshot.get(0), (Matcher)Matchers.is((Object)"0"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void snapshotMustBeUnmodifiable() {
        new CopyOnWriteHashMap().snapshot().put(0, "0");
    }
}

