/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal.locker;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.layout.StoreLayout;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.internal.locker.GlobalStoreLocker;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class GlobalStoreLockerTest {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final FileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Test
    public void failToLockSameFolderAcrossIndependentLockers() throws Exception {
        StoreLayout storeLayout = this.testDirectory.storeLayout();
        try (GlobalStoreLocker storeLocker = new GlobalStoreLocker(this.fileSystemRule.get(), storeLayout);){
            Throwable throwable;
            GlobalStoreLocker locker2;
            storeLocker.checkLock();
            try {
                locker2 = new GlobalStoreLocker(this.fileSystemRule.get(), storeLayout);
                throwable = null;
                try {
                    locker2.checkLock();
                    Assert.fail((String)"directory should be locked");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (locker2 != null) {
                        if (throwable != null) {
                            try {
                                locker2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            locker2.close();
                        }
                    }
                }
            }
            catch (StoreLockException locker2) {
                // empty catch block
            }
            try {
                locker2 = new GlobalStoreLocker(this.fileSystemRule.get(), storeLayout);
                throwable = null;
                try {
                    locker2.checkLock();
                    Assert.fail((String)"directory should be locked");
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (locker2 != null) {
                        if (throwable != null) {
                            try {
                                locker2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            locker2.close();
                        }
                    }
                }
            }
            catch (StoreLockException storeLockException) {
                // empty catch block
            }
        }
    }

    @Test
    public void allowToLockSameDirectoryIfItWasUnlocked() throws IOException {
        StoreLayout storeLayout = this.testDirectory.storeLayout();
        try (GlobalStoreLocker storeLocker = new GlobalStoreLocker(this.fileSystemRule.get(), storeLayout);){
            storeLocker.checkLock();
        }
        storeLocker = new GlobalStoreLocker(this.fileSystemRule.get(), storeLayout);
        var3_3 = null;
        try {
            storeLocker.checkLock();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (storeLocker != null) {
                if (var3_3 != null) {
                    try {
                        storeLocker.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    storeLocker.close();
                }
            }
        }
    }

    @Test
    public void allowMultipleCallstoActuallyStoreLocker() throws IOException {
        StoreLayout storeLayout = this.testDirectory.storeLayout();
        try (GlobalStoreLocker storeLocker = new GlobalStoreLocker(this.fileSystemRule.get(), storeLayout);){
            storeLocker.checkLock();
            storeLocker.checkLock();
            storeLocker.checkLock();
            storeLocker.checkLock();
            storeLocker.checkLock();
        }
    }
}

