/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring;

import java.time.Duration;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.monitoring.VmPauseMonitor;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class VmPauseMonitorTest {
    private final Consumer<VmPauseMonitor.VmPauseInfo> listener = (Consumer)Mockito.mock(Consumer.class);
    private final JobHandle jobHandle = (JobHandle)Mockito.mock(JobHandle.class);
    private final JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
    private final VmPauseMonitor monitor = (VmPauseMonitor)Mockito.spy((Object)new VmPauseMonitor(Duration.ofMillis(1L), Duration.ofMillis(0L), (Log)NullLog.getInstance(), this.jobScheduler, this.listener));

    @Before
    public void setUp() {
        ((JobScheduler)Mockito.doReturn((Object)this.jobHandle).when((Object)this.jobScheduler)).schedule((Group)ArgumentMatchers.any(Group.class), (Runnable)ArgumentMatchers.any(Runnable.class));
    }

    @Test
    public void testCtorParametersValidation() {
        VmPauseMonitorTest.assertThatFails(NullPointerException.class, () -> new VmPauseMonitor(Duration.ofSeconds(1L), Duration.ofSeconds(1L), null, this.jobScheduler, this.listener));
        VmPauseMonitorTest.assertThatFails(NullPointerException.class, () -> new VmPauseMonitor(Duration.ofSeconds(1L), Duration.ofSeconds(1L), (Log)NullLog.getInstance(), null, this.listener));
        VmPauseMonitorTest.assertThatFails(NullPointerException.class, () -> new VmPauseMonitor(Duration.ofSeconds(1L), Duration.ofSeconds(1L), (Log)NullLog.getInstance(), this.jobScheduler, null));
        VmPauseMonitorTest.assertThatFails(IllegalArgumentException.class, () -> new VmPauseMonitor(Duration.ofSeconds(0L), Duration.ofSeconds(1L), (Log)NullLog.getInstance(), this.jobScheduler, this.listener));
        VmPauseMonitorTest.assertThatFails(IllegalArgumentException.class, () -> new VmPauseMonitor(Duration.ofSeconds(1L), Duration.ofSeconds(-1L), (Log)NullLog.getInstance(), this.jobScheduler, this.listener));
        VmPauseMonitorTest.assertThatFails(IllegalArgumentException.class, () -> new VmPauseMonitor(Duration.ofSeconds(-1L), Duration.ofSeconds(1L), (Log)NullLog.getInstance(), this.jobScheduler, this.listener));
    }

    @Test
    public void testStartAndStop() {
        this.monitor.start();
        this.monitor.stop();
        ((JobScheduler)Mockito.verify((Object)this.jobScheduler)).schedule((Group)ArgumentMatchers.any(Group.class), (Runnable)ArgumentMatchers.any(Runnable.class));
        ((JobHandle)Mockito.verify((Object)this.jobHandle)).cancel(ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void testRestart() {
        this.monitor.start();
        this.monitor.stop();
        this.monitor.start();
        ((JobScheduler)Mockito.verify((Object)this.jobScheduler, (VerificationMode)Mockito.times((int)2))).schedule((Group)ArgumentMatchers.any(Group.class), (Runnable)ArgumentMatchers.any(Runnable.class));
        ((JobHandle)Mockito.verify((Object)this.jobHandle)).cancel(ArgumentMatchers.eq((boolean)true));
    }

    @Test(expected=IllegalStateException.class)
    public void testFailStopWithoutStart() {
        this.monitor.stop();
    }

    @Test(expected=IllegalStateException.class)
    public void testFailOnDoubleStart() {
        this.monitor.start();
        this.monitor.start();
    }

    @Test(expected=IllegalStateException.class)
    public void testFailOnDoubleStop() {
        this.monitor.start();
        this.monitor.stop();
        this.monitor.stop();
    }

    @Test
    public void testNotifyListener() throws Exception {
        ((VmPauseMonitor)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)this.monitor)).isStopped();
        this.monitor.monitor();
        ((Consumer)Mockito.verify(this.listener)).accept(ArgumentMatchers.any(VmPauseMonitor.VmPauseInfo.class));
    }

    private static void assertThatFails(Class<? extends Exception> exceptionClass, Runnable action) {
        try {
            action.run();
            Assert.fail((String)("Expected exception was not thrown: " + exceptionClass.getName()));
        }
        catch (Exception e) {
            Assert.assertSame(exceptionClass, e.getClass());
        }
    }
}

