/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.recovery.CorruptedLogsTruncator;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.kernel.recovery.RecoveryService;
import org.neo4j.kernel.recovery.RecoveryStartInformation;

public class RecoveryProgressIndicatorTest {
    @Test
    public void reportProgressOnRecovery() throws Throwable {
        RecoveryService recoveryService = (RecoveryService)Mockito.mock(RecoveryService.class, (Answer)Answers.RETURNS_MOCKS);
        CorruptedLogsTruncator logsTruncator = (CorruptedLogsTruncator)Mockito.mock(CorruptedLogsTruncator.class);
        RecoveryMonitor recoveryMonitor = (RecoveryMonitor)Mockito.mock(RecoveryMonitor.class);
        TransactionCursor reverseTransactionCursor = (TransactionCursor)Mockito.mock(TransactionCursor.class);
        TransactionCursor transactionCursor = (TransactionCursor)Mockito.mock(TransactionCursor.class);
        CommittedTransactionRepresentation transactionRepresentation = (CommittedTransactionRepresentation)Mockito.mock(CommittedTransactionRepresentation.class);
        int transactionsToRecover = 5;
        int expectedMax = transactionsToRecover * 2;
        int lastCommittedTransactionId = 14;
        LogPosition recoveryStartPosition = LogPosition.start((long)0L);
        int firstTxIdAfterLastCheckPoint = 10;
        RecoveryStartInformation startInformation = new RecoveryStartInformation(recoveryStartPosition, (long)firstTxIdAfterLastCheckPoint);
        Mockito.when((Object)reverseTransactionCursor.next()).thenAnswer((Answer)new NextTransactionAnswer(transactionsToRecover));
        Mockito.when((Object)transactionCursor.next()).thenAnswer((Answer)new NextTransactionAnswer(transactionsToRecover));
        Mockito.when((Object)reverseTransactionCursor.get()).thenReturn((Object)transactionRepresentation);
        Mockito.when((Object)transactionCursor.get()).thenReturn((Object)transactionRepresentation);
        Mockito.when((Object)transactionRepresentation.getCommitEntry()).thenReturn((Object)new LogEntryCommit((long)lastCommittedTransactionId, 1L));
        Mockito.when((Object)recoveryService.getRecoveryStartInformation()).thenReturn((Object)startInformation);
        Mockito.when((Object)recoveryService.getTransactionsInReverseOrder(recoveryStartPosition)).thenReturn((Object)reverseTransactionCursor);
        Mockito.when((Object)recoveryService.getTransactions(recoveryStartPosition)).thenReturn((Object)transactionCursor);
        AssertableProgressReporter progressReporter = new AssertableProgressReporter(expectedMax);
        Recovery recovery = new Recovery(recoveryService, logsTruncator, (Lifecycle)new LifecycleAdapter(), recoveryMonitor, (ProgressReporter)progressReporter, true);
        recovery.init();
        progressReporter.verify();
    }

    private static class NextTransactionAnswer
    implements Answer<Boolean> {
        private final int expectedTransactionsToRecover;
        private int invocations;

        NextTransactionAnswer(int expectedTransactionsToRecover) {
            this.expectedTransactionsToRecover = expectedTransactionsToRecover;
        }

        public Boolean answer(InvocationOnMock invocationOnMock) {
            ++this.invocations;
            return this.invocations <= this.expectedTransactionsToRecover;
        }
    }

    private static class AssertableProgressReporter
    implements ProgressReporter {
        private final int expectedMax;
        private int recoveredTransactions;
        private long max;
        private boolean completed;

        AssertableProgressReporter(int expectedMax) {
            this.expectedMax = expectedMax;
        }

        public void start(long max) {
            this.max = max;
        }

        public void progress(long add) {
            this.recoveredTransactions = (int)((long)this.recoveredTransactions + add);
        }

        public void completed() {
            this.completed = true;
        }

        public void verify() {
            Assert.assertTrue((String)"Progress reporting was not completed.", (boolean)this.completed);
            Assert.assertEquals((String)"Number of max recovered transactions is different.", (long)this.expectedMax, (long)this.max);
            Assert.assertEquals((String)"Number of recovered transactions is different.", (long)this.expectedMax, (long)this.recoveredTransactions);
        }
    }
}

