/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.impl.core.DelegatingTokenHolder;
import org.neo4j.kernel.impl.core.TokenHolder;
import org.neo4j.register.Register;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipGroupCursor;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class StubStorageCursors
implements StorageReader {
    private static final long NO_ID = -1L;
    private final AtomicLong nextPropertyId = new AtomicLong();
    private final AtomicLong nextTokenId = new AtomicLong();
    private final TokenHolder propertyKeyTokenHolder = new DelegatingTokenHolder(name -> Math.toIntExact(this.nextTokenId.getAndIncrement()), "PropertyKey");
    private final Map<Long, NodeData> nodeData = new HashMap<Long, NodeData>();
    private final Map<String, Long> labelByName = new HashMap<String, Long>();
    private final Map<Long, String> labelById = new HashMap<Long, String>();
    private final Map<String, Long> propertyKeyByName = new HashMap<String, Long>();
    private final Map<Long, String> propertyKeyById = new HashMap<Long, String>();
    private final Map<String, Long> relationshipTypeByName = new HashMap<String, Long>();
    private final Map<Long, String> relationshipTypeById = new HashMap<Long, String>();
    private final Map<Long, PropertyData> propertyData = new HashMap<Long, PropertyData>();
    private final Map<Long, RelationshipData> relationshipData = new HashMap<Long, RelationshipData>();

    public void withNode(long id) {
        this.withNode(id, new long[0]);
    }

    public void withNode(long id, long[] labels) {
        this.withNode(id, labels, Collections.emptyMap());
    }

    public void withNode(long id, long[] labels, Map<String, Value> properties) {
        this.nodeData.put(id, new NodeData(id, labels, -1L, this.propertyIdOf(properties)));
    }

    public void withRelationship(long id, long startNode, int type, long endNode) {
        this.withRelationship(id, startNode, type, endNode, Collections.emptyMap());
    }

    public void withRelationship(long id, long startNode, int type, long endNode, Map<String, Value> properties) {
        this.relationshipData.put(id, new RelationshipData(id, startNode, type, endNode, this.propertyIdOf(properties)));
    }

    private long propertyIdOf(Map<String, Value> properties) {
        if (properties.isEmpty()) {
            return -1L;
        }
        long propertyId = this.nextPropertyId.incrementAndGet();
        this.propertyData.put(propertyId, new PropertyData(properties));
        properties.keySet().forEach(arg_0 -> ((TokenHolder)this.propertyKeyTokenHolder).getOrCreateId(arg_0));
        return propertyId;
    }

    public void acquire() {
    }

    public void release() {
    }

    public void close() {
    }

    public TokenHolder propertyKeyTokenHolder() {
        return this.propertyKeyTokenHolder;
    }

    public LabelScanReader getLabelScanReader() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public IndexReader getIndexReader(IndexDescriptor index) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public IndexReader getFreshIndexReader(IndexDescriptor index) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long reserveNode() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long reserveRelationship() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int reserveLabelTokenId() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int reservePropertyKeyTokenId() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int reserveRelationshipTypeTokenId() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long getGraphPropertyReference() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<CapableIndexDescriptor> indexesGetForLabel(int labelId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<CapableIndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public CapableIndexDescriptor indexGetForName(String name) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<CapableIndexDescriptor> indexesGetAll() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<CapableIndexDescriptor> indexesGetRelatedToProperty(int propertyId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean constraintExists(ConstraintDescriptor descriptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PrimitiveLongResourceIterator nodesGetForLabel(int labelId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public CapableIndexDescriptor indexGetForSchema(SchemaDescriptor descriptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public InternalIndexState indexGetState(IndexDescriptor descriptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public IndexReference indexReference(IndexDescriptor descriptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PopulationProgress indexGetPopulationProgress(SchemaDescriptor descriptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String indexGetFailure(SchemaDescriptor descriptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public <EXCEPTION extends Exception> void relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> relationshipVisitor) throws EntityNotFoundException, EXCEPTION {
        RelationshipData data = this.relationshipData.get(relationshipId);
        if (data == null) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
        relationshipVisitor.visit(relationshipId, data.type, data.startNode, data.endNode);
    }

    public void releaseNode(long id) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void releaseRelationship(long id) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long countsForNode(int labelId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long indexSize(SchemaDescriptor descriptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public double indexUniqueValuesPercentage(SchemaDescriptor descriptor) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long nodesGetCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long relationshipsGetCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int labelCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int propertyKeyCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int relationshipTypeCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Register.DoubleLongRegister indexUpdatesAndSize(SchemaDescriptor descriptor, Register.DoubleLongRegister target) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Register.DoubleLongRegister indexSample(SchemaDescriptor descriptor, Register.DoubleLongRegister target) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean nodeExists(long id) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean relationshipExists(long id) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public <T> T getOrCreateSchemaDependantState(Class<T> type, Function<StorageReader, T> factory) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public StorageNodeCursor allocateNodeCursor() {
        return new StubStorageNodeCursor();
    }

    public StoragePropertyCursor allocatePropertyCursor() {
        return new StubStoragePropertyCursor();
    }

    public StorageRelationshipGroupCursor allocateRelationshipGroupCursor() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public StorageRelationshipTraversalCursor allocateRelationshipTraversalCursor() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public StorageRelationshipScanCursor allocateRelationshipScanCursor() {
        return new StubStorageRelationshipScanCursor();
    }

    public StorageSchemaReader schemaSnapshot() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private class StubStoragePropertyCursor
    implements StoragePropertyCursor {
        private Map.Entry<String, Value> current;
        private Iterator<Map.Entry<String, Value>> iterator;

        private StubStoragePropertyCursor() {
        }

        public void init(long reference) {
            PropertyData properties = (PropertyData)StubStorageCursors.this.propertyData.get(reference);
            this.iterator = properties != null ? properties.properties.entrySet().iterator() : Collections.emptyIterator();
        }

        public void close() {
        }

        public int propertyKey() {
            return StubStorageCursors.this.propertyKeyTokenHolder.getOrCreateId(this.current.getKey());
        }

        public ValueGroup propertyType() {
            return this.current.getValue().valueGroup();
        }

        public Value propertyValue() {
            return this.current.getValue();
        }

        public void reset() {
        }

        public boolean next() {
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                return true;
            }
            return false;
        }
    }

    private class StubStorageRelationshipScanCursor
    implements StorageRelationshipScanCursor {
        private Iterator<Long> iterator;
        private RelationshipData current;
        private long next;

        private StubStorageRelationshipScanCursor() {
        }

        public void scan() {
            this.scan(-1);
        }

        public void scan(int type) {
            this.iterator = StubStorageCursors.this.relationshipData.keySet().iterator();
            this.next = -1L;
        }

        public void single(long reference) {
            this.iterator = null;
            this.next = reference;
        }

        public long entityReference() {
            return this.current.id;
        }

        public int type() {
            return this.current.type;
        }

        public boolean hasProperties() {
            return this.current.propertyId != -1L;
        }

        public long sourceNodeReference() {
            return this.current.startNode;
        }

        public long targetNodeReference() {
            return this.current.endNode;
        }

        public long propertiesReference() {
            return this.current.propertyId;
        }

        public void visit(long relationshipId, int typeId, long startNodeId, long endNodeId) {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        public boolean next() {
            if (this.iterator != null) {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                this.next = this.iterator.next();
            }
            if (this.next != -1L) {
                this.current = (RelationshipData)StubStorageCursors.this.relationshipData.get(this.next);
                this.next = -1L;
                return true;
            }
            return false;
        }

        public void reset() {
            this.current = null;
            this.next = -1L;
        }

        public void close() {
            this.reset();
        }
    }

    private class StubStorageNodeCursor
    implements StorageNodeCursor {
        private long next;
        private NodeData current;
        private Iterator<Long> iterator;

        private StubStorageNodeCursor() {
        }

        public void scan() {
            this.iterator = StubStorageCursors.this.nodeData.keySet().iterator();
        }

        public void single(long reference) {
            this.iterator = null;
            this.next = reference;
        }

        public long entityReference() {
            return this.current.id;
        }

        public long[] labels() {
            return this.current.labels;
        }

        public boolean hasLabel(int label) {
            return ArrayUtils.contains((long[])this.current.labels, (long)label);
        }

        public boolean hasProperties() {
            return this.current.propertyId != -1L;
        }

        public long relationshipGroupReference() {
            return this.current.firstRelationship;
        }

        public long allRelationshipsReference() {
            return this.current.firstRelationship;
        }

        public long propertiesReference() {
            return this.current.propertyId;
        }

        public boolean next() {
            if (this.iterator != null) {
                this.current = this.iterator.hasNext() ? (NodeData)StubStorageCursors.this.nodeData.get(this.iterator.next()) : null;
                return true;
            }
            if (this.next != -1L) {
                this.current = (NodeData)StubStorageCursors.this.nodeData.get(this.next);
                this.next = -1L;
                return true;
            }
            return false;
        }

        public void setCurrent(long nodeReference) {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        public void reset() {
            this.iterator = null;
            this.current = null;
        }

        public boolean isDense() {
            return false;
        }

        public void close() {
            this.reset();
        }
    }

    private static class PropertyData {
        private final Map<String, Value> properties;

        PropertyData(Map<String, Value> properties) {
            this.properties = properties;
        }
    }

    private static class RelationshipData {
        private final long id;
        private final long startNode;
        private final int type;
        private final long endNode;
        private final long propertyId;

        RelationshipData(long id, long startNode, int type, long endNode, long propertyId) {
            this.id = id;
            this.startNode = startNode;
            this.type = type;
            this.endNode = endNode;
            this.propertyId = propertyId;
        }
    }

    private static class NodeData {
        private final long id;
        private final long[] labels;
        private final long firstRelationship;
        private final long propertyId;

        NodeData(long id, long[] labels, long firstRelationship, long propertyId) {
            this.id = id;
            this.labels = labels;
            this.firstRelationship = firstRelationship;
            this.propertyId = propertyId;
        }
    }
}

