/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.config.Setting;

public final class ConfigBuilder {
    private final Map<Setting<?>, String> config;

    public static ConfigBuilder configure(Setting<?> key, String value) {
        HashMap config = new HashMap();
        config.put(key, value);
        return new ConfigBuilder(config);
    }

    private ConfigBuilder(Map<Setting<?>, String> config) {
        this.config = config;
    }

    public Map<Setting<?>, String> configuration() {
        return Collections.unmodifiableMap(this.config);
    }

    public ConfigBuilder and(Setting<?> key, String value) {
        HashMap config = new HashMap(this.config);
        config.put(key, value);
        return new ConfigBuilder(config);
    }

    public Object[] asParameters() {
        return new Object[]{this};
    }

    public String toString() {
        return this.config.toString();
    }
}

