/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.mockito.matcher;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.test.mockito.matcher.IterableMatcher;

public class CollectionMatcher<T>
extends TypeSafeMatcher<Collection<T>> {
    private final Collection<T> toMatch;

    private CollectionMatcher(Collection<T> toMatch) {
        this.toMatch = toMatch;
    }

    protected boolean matchesSafely(Collection<T> objects) {
        return IterableMatcher.itemsMatches(this.toMatch, objects);
    }

    public void describeTo(Description description) {
        description.appendValueList("Collection [", ",", "]", this.toMatch);
    }

    public static <T> CollectionMatcher<T> matchesCollection(Collection<T> toMatch) {
        return new CollectionMatcher<T>(toMatch);
    }

    @SafeVarargs
    public static <T> CollectionMatcher<T> matchesCollection(T ... toMatch) {
        return new CollectionMatcher<T>(Arrays.asList(toMatch));
    }
}

