/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.unsafe.impl.batchimport.Configuration;

public class ConfigurationTest {
    @Test
    public void shouldOverrideBigPageCacheMemorySettingContainingUnit() {
        Config dbConfig = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)"2g");
        Configuration.Overridden config = new Configuration.Overridden(dbConfig);
        long memory = config.pageCacheMemory();
        Assert.assertEquals((long)Configuration.MAX_PAGE_CACHE_MEMORY, (long)memory);
    }

    @Test
    public void shouldOverrideSmallPageCacheMemorySettingContainingUnit() {
        long overridden = Settings.parseLongWithUnit((String)"10m");
        Config dbConfig = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)String.valueOf(overridden));
        Configuration.Overridden config = new Configuration.Overridden(dbConfig);
        long memory = config.pageCacheMemory();
        Assert.assertEquals((long)overridden, (long)memory);
    }

    @Test
    public void shouldParseDefaultPageCacheMemorySetting() {
        Configuration config = Configuration.DEFAULT;
        long memory = config.pageCacheMemory();
        long heuristic = ConfiguringPageCacheFactory.defaultHeuristicPageCacheMemory();
        Assert.assertTrue((boolean)this.within(memory, heuristic, Configuration.MAX_PAGE_CACHE_MEMORY));
    }

    @Test
    public void shouldCalculateCorrectMaxMemorySetting() throws Exception {
        long totalMachineMemory = OsBeanUtil.getTotalPhysicalMemory();
        Assume.assumeTrue((totalMachineMemory != -1L ? 1 : 0) != 0);
        final int percent = 70;
        Configuration config = new Configuration(){

            public long maxMemoryUsage() {
                return Configuration.calculateMaxMemoryFromPercent((int)percent);
            }
        };
        long memory = config.maxMemoryUsage();
        long expected = (long)((double)(totalMachineMemory - Runtime.getRuntime().maxMemory()) * ((double)percent / 100.0));
        long diff = Math.abs(expected - memory);
        Assert.assertThat((Object)diff, (Matcher)Matchers.lessThan((Comparable)Long.valueOf((long)((double)expected / 10.0))));
    }

    private boolean within(long value, long firstBound, long otherBound) {
        return value >= Math.min(firstBound, otherBound) && value <= Math.max(firstBound, otherBound);
    }
}

