/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.DataImporter;
import org.neo4j.unsafe.impl.batchimport.NodeImporter;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

@ExtendWith(value={TestDirectoryExtension.class})
class NodeImporterTest {
    @Inject
    private TestDirectory directory;

    NodeImporterTest() {
    }

    @Test
    void shouldHandleLargeAmountsOfLabels() throws IOException {
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory();
        FileSystemAbstraction fs = this.directory.getFileSystem();
        swapperFactory.open(fs, null);
        IdMapper idMapper = (IdMapper)Mockito.mock(IdMapper.class);
        JobScheduler scheduler = JobSchedulerFactory.createScheduler();
        try (Lifespan life = new Lifespan(new Lifecycle[]{scheduler});
             MuninnPageCache pageCache = new MuninnPageCache((PageSwapperFactory)swapperFactory, 1000, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, EmptyVersionContextSupplier.EMPTY, scheduler);
             BatchingNeoStores stores = BatchingNeoStores.batchingNeoStoresWithExternalPageCache((FileSystemAbstraction)fs, (PageCache)pageCache, (PageCacheTracer)PageCacheTracer.NULL, (File)this.directory.storeDir(), (RecordFormats)Standard.LATEST_RECORD_FORMATS, (Configuration)Configuration.DEFAULT, (LogService)NullLogService.getInstance(), (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)Config.defaults());){
            Object[] labels;
            stores.createNew();
            int numberOfLabels = 50;
            long nodeId = 0L;
            try (NodeImporter importer = new NodeImporter(stores, idMapper, new DataImporter.Monitor());){
                importer.id(nodeId);
                labels = new String[numberOfLabels];
                for (int i = 0; i < labels.length; ++i) {
                    labels[i] = "Label" + i;
                }
                importer.labels(labels);
                importer.endOfEntity();
            }
            NodeStore nodeStore = stores.getNodeStore();
            NodeRecord record = (NodeRecord)nodeStore.getRecord(nodeId, nodeStore.newRecord(), RecordLoad.NORMAL);
            labels = NodeLabelsField.parseLabelsField((NodeRecord)record).get(nodeStore);
            Assertions.assertEquals((int)numberOfLabels, (int)labels.length);
        }
    }
}

