/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class RelationshipCountsProcessorTest {
    private static final int ANY = -1;
    private final NodeLabelsCache nodeLabelCache = (NodeLabelsCache)Mockito.mock(NodeLabelsCache.class);
    private final CountsAccessor.Updater countsUpdater = (CountsAccessor.Updater)Mockito.mock(CountsAccessor.Updater.class);

    @Test
    public void shouldHandleBigNumberOfLabelsAndRelationshipTypes() {
        int relTypeCount = 256;
        int labelCount = 0x400000;
        NumberArrayFactory numberArrayFactory = (NumberArrayFactory)Mockito.mock(NumberArrayFactory.class);
        new RelationshipCountsProcessor(this.nodeLabelCache, labelCount, relTypeCount, this.countsUpdater, numberArrayFactory);
        ((NumberArrayFactory)Mockito.verify((Object)numberArrayFactory, (VerificationMode)Mockito.times((int)2))).newLongArray(ArgumentMatchers.longThat((ArgumentMatcher)new IsNonNegativeLong()), ArgumentMatchers.anyLong());
    }

    @Test
    public void testRelationshipCountersUpdates() {
        int relationTypes = 2;
        int labels = 3;
        NodeLabelsCache.Client client = (NodeLabelsCache.Client)Mockito.mock(NodeLabelsCache.Client.class);
        Mockito.when((Object)this.nodeLabelCache.newClient()).thenReturn((Object)client);
        Mockito.when((Object)this.nodeLabelCache.get((NodeLabelsCache.Client)ArgumentMatchers.eq((Object)client), ArgumentMatchers.eq((long)1L), (int[])ArgumentMatchers.any(int[].class))).thenReturn((Object)new int[]{0, 2});
        Mockito.when((Object)this.nodeLabelCache.get((NodeLabelsCache.Client)ArgumentMatchers.eq((Object)client), ArgumentMatchers.eq((long)2L), (int[])ArgumentMatchers.any(int[].class))).thenReturn((Object)new int[]{1});
        Mockito.when((Object)this.nodeLabelCache.get((NodeLabelsCache.Client)ArgumentMatchers.eq((Object)client), ArgumentMatchers.eq((long)3L), (int[])ArgumentMatchers.any(int[].class))).thenReturn((Object)new int[]{1, 2});
        Mockito.when((Object)this.nodeLabelCache.get((NodeLabelsCache.Client)ArgumentMatchers.eq((Object)client), ArgumentMatchers.eq((long)4L), (int[])ArgumentMatchers.any(int[].class))).thenReturn((Object)new int[0]);
        RelationshipCountsProcessor countsProcessor = new RelationshipCountsProcessor(this.nodeLabelCache, labels, relationTypes, this.countsUpdater, NumberArrayFactory.AUTO_WITHOUT_PAGECACHE);
        countsProcessor.process(this.record(1L, 0, 3L));
        countsProcessor.process(this.record(2L, 1, 4L));
        countsProcessor.done();
        ((CountsAccessor.Updater)Mockito.verify((Object)this.countsUpdater)).incrementRelationshipCount(-1L, -1, -1L, 2L);
        ((CountsAccessor.Updater)Mockito.verify((Object)this.countsUpdater)).incrementRelationshipCount(-1L, 0, -1L, 1L);
        ((CountsAccessor.Updater)Mockito.verify((Object)this.countsUpdater)).incrementRelationshipCount(-1L, 1, -1L, 1L);
        ((CountsAccessor.Updater)Mockito.verify((Object)this.countsUpdater)).incrementRelationshipCount(0L, 0, -1L, 1L);
        ((CountsAccessor.Updater)Mockito.verify((Object)this.countsUpdater)).incrementRelationshipCount(2L, 0, -1L, 1L);
        ((CountsAccessor.Updater)Mockito.verify((Object)this.countsUpdater)).incrementRelationshipCount(-1L, 0, 1L, 1L);
        ((CountsAccessor.Updater)Mockito.verify((Object)this.countsUpdater)).incrementRelationshipCount(-1L, 0, 2L, 1L);
    }

    private RelationshipRecord record(long startNode, int type, long endNode) {
        RelationshipRecord record = new RelationshipRecord(0L);
        record.setInUse(true);
        record.setFirstNode(startNode);
        record.setSecondNode(endNode);
        record.setType(type);
        return record;
    }

    private class IsNonNegativeLong
    implements ArgumentMatcher<Long> {
        private IsNonNegativeLong() {
        }

        public boolean matches(Long argument) {
            return argument != null && argument >= 0L;
        }
    }
}

