/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.rule.TestDirectory;

public class NumberArrayPageCacheTestSupport {
    static Fixture prepareDirectoryAndPageCache(Class<?> testClass) throws IOException {
        DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
        TestDirectory testDirectory = TestDirectory.testDirectory(testClass, (FileSystemAbstraction)fileSystem);
        File dir = testDirectory.prepareDirectoryForTest("test");
        ThreadPoolJobScheduler scheduler = new ThreadPoolJobScheduler();
        PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem, (JobScheduler)scheduler);
        return new Fixture(pageCache, (FileSystemAbstraction)fileSystem, dir, scheduler);
    }

    public static class Fixture
    implements AutoCloseable {
        public final PageCache pageCache;
        public final FileSystemAbstraction fileSystem;
        public final File directory;
        private final ThreadPoolJobScheduler scheduler;

        private Fixture(PageCache pageCache, FileSystemAbstraction fileSystem, File directory, ThreadPoolJobScheduler scheduler) {
            this.pageCache = pageCache;
            this.fileSystem = fileSystem;
            this.directory = directory;
            this.scheduler = scheduler;
        }

        @Override
        public void close() throws Exception {
            this.pageCache.close();
            this.scheduler.close();
            this.fileSystem.close();
        }
    }
}

