/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.DetailLevel;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public class ControlledStep<T>
implements Step<T>,
StatsProvider {
    private final String name;
    private final Map<Key, ControlledStat> stats = new HashMap<Key, ControlledStat>();
    private final int maxProcessors;
    private volatile int numberOfProcessors = 1;
    private final CountDownLatch completed = new CountDownLatch(1);

    public static ControlledStep<?> stepWithAverageOf(String name, int maxProcessors, long avg) {
        return ControlledStep.stepWithStats(name, maxProcessors, Keys.avg_processing_time, avg);
    }

    public static ControlledStep<?> stepWithStats(String name, int maxProcessors, Map<Key, Long> statistics) {
        ControlledStep step = new ControlledStep(name, maxProcessors);
        for (Map.Entry<Key, Long> statistic : statistics.entrySet()) {
            step.setStat(statistic.getKey(), statistic.getValue());
        }
        return step;
    }

    public static ControlledStep<?> stepWithStats(String name, int maxProcessors, Object ... statisticsAltKeyAndValue) {
        return ControlledStep.stepWithStats(name, maxProcessors, MapUtil.genericMap((Object[])statisticsAltKeyAndValue));
    }

    public ControlledStep(String name, int maxProcessors) {
        this(name, maxProcessors, 1);
    }

    public ControlledStep(String name, int maxProcessors, int initialProcessorCount) {
        this.maxProcessors = maxProcessors == 0 ? Integer.MAX_VALUE : maxProcessors;
        this.name = name;
        this.processors(initialProcessorCount - 1);
    }

    public ControlledStep<T> setProcessors(int numberOfProcessors) {
        this.numberOfProcessors = numberOfProcessors;
        return this;
    }

    public int processors(int delta) {
        if (delta > 0) {
            this.numberOfProcessors = Integer.min(this.numberOfProcessors + delta, this.maxProcessors);
        } else if (delta < 0) {
            this.numberOfProcessors = Integer.max(1, this.numberOfProcessors + delta);
        }
        return this.numberOfProcessors;
    }

    public int maxProcessors() {
        return this.maxProcessors;
    }

    public String name() {
        return this.name;
    }

    public long receive(long ticket, T batch) {
        throw new UnsupportedOperationException("Cannot participate in actual processing yet");
    }

    public void setStat(Key key, long value) {
        this.stats.put(key, new ControlledStat(value));
    }

    public StepStats stats() {
        return new StepStats(this.name, !this.isCompleted(), Arrays.asList(this));
    }

    public void endOfUpstream() {
    }

    public boolean isCompleted() {
        return this.completed.getCount() == 0L;
    }

    public void awaitCompleted() throws InterruptedException {
        this.completed.await();
    }

    public void setDownstream(Step<?> downstreamStep) {
    }

    public void receivePanic(Throwable cause) {
    }

    public void close() {
    }

    public Stat stat(Key key) {
        return this.stats.get(key);
    }

    public void start(int orderingGuarantees) {
    }

    public Key[] keys() {
        return this.stats.keySet().toArray(new Key[this.stats.size()]);
    }

    public void complete() {
        this.completed.countDown();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name() + ", " + this.stats + "]";
    }

    private static class ControlledStat
    implements Stat {
        private final long value;

        ControlledStat(long value) {
            this.value = value;
        }

        public DetailLevel detailLevel() {
            return DetailLevel.BASIC;
        }

        public long asLong() {
            return this.value;
        }

        public String toString() {
            return "" + this.value;
        }
    }
}

