/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ControlledStep;
import org.neo4j.unsafe.impl.batchimport.staging.DynamicProcessorAssigner;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;

public class DynamicProcessorAssignerTest {
    @Test
    public void shouldAssignProcessorsToSlowestStep() {
        Configuration config = this.config(10, 5);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config);
        ControlledStep<?> slowStep = ControlledStep.stepWithStats("slow", 0, Keys.avg_processing_time, 10L, Keys.done_batches, 10L);
        ControlledStep<?> fastStep = ControlledStep.stepWithStats("fast", 0, Keys.avg_processing_time, 2L, Keys.done_batches, 10L);
        StageExecution execution = this.executionOf(config, slowStep, fastStep);
        assigner.start(execution);
        assigner.check(execution);
        Assert.assertEquals((long)4L, (long)slowStep.processors(0));
        Assert.assertEquals((long)1L, (long)fastStep.processors(0));
    }

    @Test
    public void shouldMoveProcessorFromOverlyAssignedStep() {
        Configuration config = this.config(10, 5);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config);
        ControlledStep<?> slowStep = ControlledStep.stepWithStats("slow", 0, Keys.avg_processing_time, 6L, Keys.done_batches, 10L).setProcessors(2);
        ControlledStep<?> fastStep = ControlledStep.stepWithStats("fast", 0, Keys.avg_processing_time, 2L, Keys.done_batches, 10L).setProcessors(3);
        StageExecution execution = this.executionOf(config, slowStep, fastStep);
        assigner.start(execution);
        assigner.check(execution);
        Assert.assertEquals((long)2L, (long)fastStep.processors(0));
        Assert.assertEquals((long)3L, (long)slowStep.processors(0));
    }

    @Test
    public void shouldNotMoveProcessorFromFastStepSoThatItBecomesBottleneck() {
        Configuration config = this.config(10, 4);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config);
        ControlledStep<?> slowStep = ControlledStep.stepWithStats("slow", 1, Keys.avg_processing_time, 10L, Keys.done_batches, 10L);
        ControlledStep<?> fastStep = ControlledStep.stepWithStats("fast", 0, Keys.avg_processing_time, 7L, Keys.done_batches, 10L).setProcessors(3);
        StageExecution execution = this.executionOf(config, slowStep, fastStep);
        assigner.start(execution);
        assigner.check(execution);
        Assert.assertEquals((long)3L, (long)fastStep.processors(0));
        Assert.assertEquals((long)1L, (long)slowStep.processors(0));
    }

    @Test
    public void shouldHandleZeroAverage() {
        Configuration config = this.config(10, 5);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config);
        ControlledStep<?> aStep = ControlledStep.stepWithStats("slow", 0, Keys.avg_processing_time, 0L, Keys.done_batches, 0L);
        ControlledStep<?> anotherStep = ControlledStep.stepWithStats("fast", 0, Keys.avg_processing_time, 0L, Keys.done_batches, 0L);
        StageExecution execution = this.executionOf(config, aStep, anotherStep);
        assigner.start(execution);
        assigner.check(execution);
        Assert.assertEquals((long)1L, (long)aStep.processors(0));
        Assert.assertEquals((long)1L, (long)anotherStep.processors(0));
    }

    @Test
    public void shouldMoveProcessorFromNotOnlyFastestStep() {
        Configuration config = this.config(10, 5);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config);
        ControlledStep<?> wayFastest = ControlledStep.stepWithStats("wayFastest", 0, Keys.avg_processing_time, 50L, Keys.done_batches, 20L);
        ControlledStep<?> fast = ControlledStep.stepWithStats("fast", 0, Keys.avg_processing_time, 100L, Keys.done_batches, 20L).setProcessors(3);
        ControlledStep<?> slow = ControlledStep.stepWithStats("slow", 2, Keys.avg_processing_time, 220L, Keys.done_batches, 20L);
        StageExecution execution = this.executionOf(config, slow, wayFastest, fast);
        assigner.start(execution);
        assigner.check(execution);
        Assert.assertEquals((long)2L, (long)fast.processors(0));
        Assert.assertEquals((long)2L, (long)slow.processors(0));
    }

    @Test
    public void shouldNotMoveProcessorFromOverlyAssignedStepIfRemainingPermits() {
        Configuration config = this.config(10, 10);
        DynamicProcessorAssigner assigner = new DynamicProcessorAssigner(config);
        ControlledStep<?> wayFastest = ControlledStep.stepWithStats("wayFastest", 0, Keys.avg_processing_time, 50L, Keys.done_batches, 20L);
        ControlledStep<?> fast = ControlledStep.stepWithStats("fast", 0, Keys.avg_processing_time, 100L, Keys.done_batches, 20L).setProcessors(3);
        ControlledStep<?> slow = ControlledStep.stepWithStats("slow", 2, Keys.avg_processing_time, 220L, Keys.done_batches, 20L);
        StageExecution execution = this.executionOf(config, slow, wayFastest, fast);
        assigner.start(execution);
        assigner.check(execution);
        Assert.assertEquals((long)3L, (long)fast.processors(0));
        Assert.assertEquals((long)2L, (long)slow.processors(0));
    }

    private Configuration config(final int movingAverage, final int processors) {
        return new Configuration(){

            public int movingAverageSize() {
                return movingAverage;
            }

            public int maxNumberOfProcessors() {
                return processors;
            }
        };
    }

    private StageExecution executionOf(Configuration config, Step<?> ... steps) {
        return new StageExecution("Test", null, config, Arrays.asList(steps), 1);
    }
}

