/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.test.Barrier;
import org.neo4j.test.rule.concurrent.OtherThreadRule;
import org.neo4j.unsafe.impl.batchimport.store.PageCacheFlusher;

public class PageCacheFlusherTest {
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule();

    @Test(timeout=10000L)
    public void shouldWaitForCompletionInHalt() throws Exception {
        PageCache pageCache = (PageCache)Mockito.mock(PageCache.class);
        Barrier.Control barrier = new Barrier.Control();
        ((PageCache)Mockito.doAnswer(invocation -> {
            barrier.reached();
            return null;
        }).when((Object)pageCache)).flushAndForce();
        PageCacheFlusher flusher = new PageCacheFlusher(pageCache);
        flusher.start();
        barrier.await();
        Future halt = this.t2.execute(state -> {
            flusher.halt();
            return null;
        });
        this.t2.get().waitUntilWaiting(details -> details.isAt(PageCacheFlusher.class, "halt"));
        barrier.release();
        halt.get();
    }

    @Test
    public void shouldExitOnErrorInHalt() throws Exception {
        PageCache pageCache = (PageCache)Mockito.mock(PageCache.class);
        RuntimeException failure = new RuntimeException();
        ((PageCache)Mockito.doAnswer(invocation -> {
            throw failure;
        }).when((Object)pageCache)).flushAndForce();
        PageCacheFlusher flusher = new PageCacheFlusher(pageCache);
        flusher.run();
        try {
            flusher.halt();
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)failure, (Object)e);
        }
    }
}

