/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Comparator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.schema.IndexProgressor;

public class NativeDistinctValuesProgressor<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexProgressor<KEY, VALUE> {
    private final IndexLayout<KEY, VALUE> layout;
    private final KEY prev;
    private final Comparator<KEY> comparator;
    private boolean first = true;
    private long countForCurrentValue;
    private boolean last;

    NativeDistinctValuesProgressor(RawCursor<Hit<KEY, VALUE>, IOException> seeker, IndexProgressor.NodeValueClient client, Collection<RawCursor<Hit<KEY, VALUE>, IOException>> toRemoveFromOnClose, IndexLayout<KEY, VALUE> layout, Comparator<KEY> comparator) {
        super(seeker, client, toRemoveFromOnClose);
        this.layout = layout;
        this.prev = (NativeIndexKey)((Object)layout.newKey());
        this.comparator = comparator;
    }

    public boolean next() {
        try {
            while (this.seeker.next()) {
                NativeIndexKey key = (NativeIndexKey)((Object)((Hit)this.seeker.get()).key());
                if (this.first) {
                    this.first = false;
                    this.countForCurrentValue = 1L;
                    this.layout.copyKey((Object)key, this.prev);
                    continue;
                }
                if (this.comparator.compare(this.prev, (KEY)((Object)key)) == 0) {
                    ++this.countForCurrentValue;
                    continue;
                }
                boolean accepted = this.client.acceptNode(this.countForCurrentValue, this.extractValues(this.prev));
                this.countForCurrentValue = 1L;
                this.layout.copyKey((Object)key, this.prev);
                if (!accepted) continue;
                return true;
            }
            boolean finalResult = !this.first && !this.last && this.client.acceptNode(this.countForCurrentValue, this.extractValues(this.prev));
            this.last = true;
            return finalResult;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

