/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;

abstract class AbstractLockService<HANDLE>
implements LockService {
    AbstractLockService() {
    }

    @Override
    public Lock acquireNodeLock(long nodeId, LockService.LockType type) {
        return this.lock(new LockedNode(nodeId));
    }

    @Override
    public Lock acquireRelationshipLock(long relationshipId, LockService.LockType type) {
        return this.lock(new LockedRelationship(relationshipId));
    }

    private Lock lock(LockedEntity key) {
        return new LockReference(key, this.acquire(key));
    }

    protected abstract HANDLE acquire(LockedEntity var1);

    protected abstract void release(LockedEntity var1, HANDLE var2);

    static final class LockedRelationship
    extends LockedPropertyContainer {
        LockedRelationship(long relationshipId) {
            super(relationshipId);
        }
    }

    static final class LockedNode
    extends LockedPropertyContainer {
        LockedNode(long nodeId) {
            super(nodeId);
        }
    }

    static class LockedPropertyContainer
    extends LockedEntity {
        private final long id;

        LockedPropertyContainer(long id) {
            this.id = id;
        }

        @Override
        void toString(StringBuilder repr) {
            repr.append("id=").append(this.id);
        }

        @Override
        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj != null && obj.getClass().equals(this.getClass())) {
                LockedPropertyContainer that = (LockedPropertyContainer)obj;
                return this.id == that.id;
            }
            return false;
        }
    }

    private class LockReference
    extends Lock {
        private final LockedEntity key;
        private HANDLE handle;

        LockReference(LockedEntity key, HANDLE handle) {
            this.key = key;
            this.handle = handle;
        }

        public String toString() {
            StringBuilder repr = new StringBuilder(this.key.getClass().getSimpleName()).append('[');
            this.key.toString(repr);
            if (this.handle != null) {
                repr.append("; HELD_BY=").append(this.handle);
            } else {
                repr.append("; RELEASED");
            }
            return repr.append(']').toString();
        }

        @Override
        public void release() {
            if (this.handle == null) {
                return;
            }
            try {
                AbstractLockService.this.release(this.key, this.handle);
            }
            finally {
                this.handle = null;
            }
        }
    }

    protected static abstract class LockedEntity {
        private LockedEntity() {
        }

        public final String toString() {
            StringBuilder repr = new StringBuilder(this.getClass().getSimpleName()).append('[');
            this.toString(repr);
            return repr.append(']').toString();
        }

        abstract void toString(StringBuilder var1);

        public abstract int hashCode();

        public abstract boolean equals(Object var1);
    }
}

