/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreFailureException;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.StoreVersion;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.store.id.ReadOnlyIdGeneratorFactory;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.participant.AbstractStoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.participant.StoreMigratorFileOperation;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class CountsMigrator
extends AbstractStoreMigrationParticipant {
    private static final Iterable<DatabaseFile> COUNTS_STORE_FILES = Iterables.iterable((Object[])new DatabaseFile[]{DatabaseFile.COUNTS_STORE_A, DatabaseFile.COUNTS_STORE_B});
    private final Config config;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private boolean migrated;

    public CountsMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, Config config) {
        super("Counts store");
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
    }

    @Override
    public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progressMonitor, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        if (CountsMigrator.countStoreRebuildRequired(versionToMigrateFrom)) {
            StoreMigratorFileOperation.fileOperation(FileOperation.DELETE, this.fileSystem, migrationLayout, migrationLayout, COUNTS_STORE_FILES, true, null);
            File neoStore = directoryLayout.metadataStore();
            long lastTxId = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
            try {
                this.rebuildCountsFromScratch(directoryLayout, migrationLayout, lastTxId, progressMonitor, versionToMigrateTo, this.pageCache, (LogProvider)NullLogProvider.getInstance());
            }
            catch (StoreFailureException e) {
                this.rebuildCountsFromScratch(directoryLayout, migrationLayout, lastTxId, progressMonitor, versionToMigrateFrom, this.pageCache, (LogProvider)NullLogProvider.getInstance());
            }
            this.migrated = true;
        }
    }

    @Override
    public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToUpgradeFrom, String versionToUpgradeTo) throws IOException {
        if (this.migrated) {
            StoreMigratorFileOperation.fileOperation(FileOperation.DELETE, this.fileSystem, directoryLayout, directoryLayout, COUNTS_STORE_FILES, true, null);
            StoreMigratorFileOperation.fileOperation(FileOperation.MOVE, this.fileSystem, migrationLayout, directoryLayout, COUNTS_STORE_FILES, true, ExistingTargetStrategy.OVERWRITE);
        }
    }

    @Override
    public void cleanup(DatabaseLayout migrationLayout) throws IOException {
        this.fileSystem.deleteRecursively(migrationLayout.databaseDirectory());
    }

    public String toString() {
        return "Kernel Node Count Rebuilder";
    }

    static boolean countStoreRebuildRequired(String versionToMigrateFrom) {
        return StandardV2_3.STORE_VERSION.equals(versionToMigrateFrom) || StandardV3_0.STORE_VERSION.equals(versionToMigrateFrom) || StoreVersion.HIGH_LIMIT_V3_0_0.versionString().equals(versionToMigrateFrom) || StoreVersion.HIGH_LIMIT_V3_0_6.versionString().equals(versionToMigrateFrom) || StoreVersion.HIGH_LIMIT_V3_1_0.versionString().equals(versionToMigrateFrom);
    }

    private void rebuildCountsFromScratch(DatabaseLayout sourceStructure, DatabaseLayout migrationStructure, long lastTxId, ProgressReporter progressMonitor, String expectedStoreVersion, PageCache pageCache, LogProvider logProvider) {
        RecordFormats recordFormats = RecordFormatSelector.selectForVersion(expectedStoreVersion);
        ReadOnlyIdGeneratorFactory idGeneratorFactory = new ReadOnlyIdGeneratorFactory(this.fileSystem);
        StoreFactory storeFactory = new StoreFactory(sourceStructure, this.config, idGeneratorFactory, pageCache, this.fileSystem, recordFormats, logProvider, EmptyVersionContextSupplier.EMPTY, new OpenOption[0]);
        try (NeoStores neoStores = storeFactory.openNeoStores(StoreType.NODE, StoreType.RELATIONSHIP, StoreType.LABEL_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN);){
            neoStores.verifyStoreOk();
            NodeStore nodeStore = neoStores.getNodeStore();
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            try (Lifespan life = new Lifespan(new Lifecycle[0]);){
                int highLabelId = (int)neoStores.getLabelTokenStore().getHighId();
                int highRelationshipTypeId = (int)neoStores.getRelationshipTypeTokenStore().getHighId();
                CountsComputer initializer = new CountsComputer(lastTxId, nodeStore, relationshipStore, highLabelId, highRelationshipTypeId, NumberArrayFactory.auto(pageCache, migrationStructure.databaseDirectory(), true, NumberArrayFactory.NO_MONITOR), progressMonitor);
                life.add((Lifecycle)new CountsTracker(logProvider, this.fileSystem, pageCache, this.config, migrationStructure, EmptyVersionContextSupplier.EMPTY).setInitializer(initializer));
            }
        }
    }
}

