/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.storageengine.api.StorageCommand;

public class CommittedTransactionRepresentation {
    private final LogEntryStart startEntry;
    private final TransactionRepresentation transactionRepresentation;
    private final LogEntryCommit commitEntry;

    public CommittedTransactionRepresentation(LogEntryStart startEntry, TransactionRepresentation transactionRepresentation, LogEntryCommit commitEntry) {
        this.startEntry = startEntry;
        this.transactionRepresentation = transactionRepresentation;
        this.commitEntry = commitEntry;
    }

    public void accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        this.transactionRepresentation.accept(visitor);
    }

    public LogEntryStart getStartEntry() {
        return this.startEntry;
    }

    public TransactionRepresentation getTransactionRepresentation() {
        return this.transactionRepresentation;
    }

    public LogEntryCommit getCommitEntry() {
        return this.commitEntry;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.startEntry + ", " + this.transactionRepresentation + ", " + this.commitEntry + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommittedTransactionRepresentation that = (CommittedTransactionRepresentation)o;
        return this.commitEntry.equals(that.commitEntry) && this.startEntry.equals(that.startEntry) && this.transactionRepresentation.equals(that.transactionRepresentation);
    }

    public int hashCode() {
        int result = this.startEntry.hashCode();
        result = 31 * result + this.transactionRepresentation.hashCode();
        result = 31 * result + this.commitEntry.hashCode();
        return result;
    }
}

