/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.LockTracer;

class TwoPhaseNodeForRelationshipLocking {
    private final ThrowingConsumer<Long, KernelException> relIdAction;
    private long[] sortedNodeIds;
    private MutableLongSet relIds;
    private static final long[] EMPTY = new long[0];
    private final Locks.Client locks;
    private final LockTracer lockTracer;

    TwoPhaseNodeForRelationshipLocking(ThrowingConsumer<Long, KernelException> relIdAction, Locks.Client locks, LockTracer lockTracer) {
        this.relIdAction = relIdAction;
        this.locks = locks;
        this.lockTracer = lockTracer;
    }

    void lockAllNodesAndConsumeRelationships(long nodeId, Transaction transaction, NodeCursor nodes) throws KernelException {
        boolean retry;
        do {
            retry = false;
            this.relIds = new LongHashSet();
            this.collectAndSortNodeIds(nodeId, transaction, nodes);
            this.lockAllNodes(this.sortedNodeIds);
            transaction.dataRead().singleNode(nodeId, nodes);
            if (!nodes.next()) continue;
            RelationshipSelectionCursor rels = RelationshipSelections.allCursor((CursorFactory)transaction.cursors(), (NodeCursor)nodes, null);
            Object object = null;
            try {
                while (rels.next() && !retry) {
                    if (this.relIds.contains(rels.relationshipReference())) continue;
                    retry = true;
                    this.unlockAllNodes(this.sortedNodeIds);
                    this.sortedNodeIds = null;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (rels != null) {
                    if (object != null) {
                        try {
                            rels.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        rels.close();
                    }
                }
            }
        } while (retry);
        long[] sortedRelIds = this.relIds.toSortedArray();
        if (sortedRelIds.length > 0) {
            this.locks.acquireExclusive(this.lockTracer, ResourceTypes.RELATIONSHIP, sortedRelIds);
            for (Object relId : (Object)sortedRelIds) {
                this.relIdAction.accept((Object)((long)relId));
            }
        }
    }

    private void collectAndSortNodeIds(long nodeId, Transaction transaction, NodeCursor nodes) {
        LongHashSet nodeIdSet = new LongHashSet();
        nodeIdSet.add(nodeId);
        Read read = transaction.dataRead();
        read.singleNode(nodeId, nodes);
        if (!nodes.next()) {
            this.sortedNodeIds = EMPTY;
            return;
        }
        try (RelationshipSelectionCursor rels = RelationshipSelections.allCursor((CursorFactory)transaction.cursors(), (NodeCursor)nodes, null);){
            while (rels.next()) {
                this.relIds.add(rels.relationshipReference());
                nodeIdSet.add(rels.sourceNodeReference());
                nodeIdSet.add(rels.targetNodeReference());
            }
        }
        this.sortedNodeIds = nodeIdSet.toSortedArray();
    }

    private void lockAllNodes(long[] nodeIds) {
        this.locks.acquireExclusive(this.lockTracer, ResourceTypes.NODE, nodeIds);
    }

    private void unlockAllNodes(long[] nodeIds) {
        this.locks.releaseExclusive(ResourceTypes.NODE, nodeIds);
    }
}

