/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.scheduler.ThreadPool;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;

final class ThreadPoolManager {
    private final ConcurrentHashMap<Group, ThreadPool> pools = new ConcurrentHashMap();
    private final Function<Group, ThreadPool> poolBuilder = group -> new ThreadPool((Group)group, topLevelGroup);

    ThreadPoolManager(ThreadGroup topLevelGroup) {
    }

    ThreadPool getThreadPool(Group group) {
        return this.pools.computeIfAbsent(group, this.poolBuilder);
    }

    JobHandle submit(Group group, Runnable job) {
        ThreadPool threadPool = this.getThreadPool(group);
        return threadPool.submit(job);
    }

    public InterruptedException shutDownAll() {
        this.pools.forEach((group, pool) -> pool.cancelAllJobs());
        this.pools.forEach((group, pool) -> pool.shutDown());
        return this.pools.values().stream().map(ThreadPool::getShutdownException).reduce(null, Exceptions::chain);
    }
}

