/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.collection.PrimitiveLongArrayQueue;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;

public class FreeIdKeeper
implements Closeable {
    private static final int ID_ENTRY_SIZE = 8;
    private final PrimitiveLongArrayQueue freeIds = new PrimitiveLongArrayQueue();
    private final PrimitiveLongArrayQueue readFromDisk = new PrimitiveLongArrayQueue();
    private final StoreChannel channel;
    private final int batchSize;
    private final boolean aggressiveMode;
    private long freeIdCount;
    private long stackPosition;
    private long initialPosition;

    public FreeIdKeeper(StoreChannel channel, int batchSize, boolean aggressiveMode) throws IOException {
        this.channel = channel;
        this.batchSize = batchSize;
        this.aggressiveMode = aggressiveMode;
        this.stackPosition = this.initialPosition = channel.size();
        this.freeIdCount = this.stackPosition / 8L;
    }

    static long countFreeIds(StoreChannel channel) throws IOException {
        return channel.size() / 8L;
    }

    public void freeId(long id) {
        this.freeIds.enqueue(id);
        ++this.freeIdCount;
        if (this.freeIds.size() >= this.batchSize) {
            long endPosition = this.flushFreeIds(ByteBuffer.allocate(this.batchSize * 8));
            if (this.aggressiveMode) {
                this.stackPosition = endPosition;
            }
        }
    }

    private void truncate(long position) {
        try {
            this.channel.truncate(position);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to truncate", e);
        }
    }

    public long getId() {
        long result;
        if (this.freeIds.size() > 0 && this.aggressiveMode) {
            result = this.freeIds.dequeue();
            --this.freeIdCount;
        } else {
            result = this.getIdFromDisk();
            if (result != -1L) {
                --this.freeIdCount;
            }
        }
        return result;
    }

    public long[] getIds(int numberOfIds) {
        if (this.freeIdCount == 0L) {
            return PrimitiveLongCollections.EMPTY_LONG_ARRAY;
        }
        int reusableIds = (int)Math.min((long)numberOfIds, this.freeIdCount);
        long[] ids = new long[reusableIds];
        int cursor = 0;
        while (cursor < reusableIds && !this.freeIds.isEmpty()) {
            ids[cursor++] = this.freeIds.dequeue();
        }
        while (cursor < reusableIds) {
            ids[cursor++] = this.getIdFromDisk();
        }
        this.freeIdCount -= (long)reusableIds;
        return ids;
    }

    private long getIdFromDisk() {
        if (this.readFromDisk.isEmpty()) {
            this.readIdBatch();
        }
        if (!this.readFromDisk.isEmpty()) {
            return this.readFromDisk.dequeue();
        }
        return -1L;
    }

    public long getCount() {
        return this.freeIdCount;
    }

    private void readIdBatch() {
        try {
            this.readIdBatch0();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed reading free id batch", e);
        }
    }

    private void readIdBatch0() throws IOException {
        if (this.stackPosition == 0L) {
            return;
        }
        long startPosition = Math.max(this.stackPosition - (long)(this.batchSize * 8), 0L);
        int bytesToRead = Math.toIntExact(this.stackPosition - startPosition);
        ByteBuffer readBuffer = ByteBuffer.allocate(bytesToRead);
        this.channel.position(startPosition);
        this.channel.readAll(readBuffer);
        this.stackPosition = startPosition;
        readBuffer.flip();
        int idsRead = bytesToRead / 8;
        for (int i = 0; i < idsRead; ++i) {
            long id = readBuffer.getLong();
            this.readFromDisk.enqueue(id);
        }
        if (this.aggressiveMode) {
            this.truncate(startPosition);
        }
    }

    private long flushFreeIds(ByteBuffer writeBuffer) {
        try {
            return this.flushFreeIds0(writeBuffer);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to write free id batch", e);
        }
    }

    private long flushFreeIds0(ByteBuffer writeBuffer) throws IOException {
        this.channel.position(this.channel.size());
        writeBuffer.clear();
        while (!this.freeIds.isEmpty()) {
            long id = this.freeIds.dequeue();
            if (id == -1L) continue;
            writeBuffer.putLong(id);
            if (writeBuffer.position() != writeBuffer.capacity()) continue;
            writeBuffer.flip();
            this.channel.writeAll(writeBuffer);
            writeBuffer.clear();
        }
        writeBuffer.flip();
        if (writeBuffer.hasRemaining()) {
            this.channel.writeAll(writeBuffer);
        }
        return this.channel.position();
    }

    @Override
    public void close() throws IOException {
        ByteBuffer writeBuffer = ByteBuffer.allocate(this.batchSize * 8);
        this.flushFreeIds(writeBuffer);
        this.freeIds.addAll(this.readFromDisk);
        this.flushFreeIds(writeBuffer);
        if (!this.aggressiveMode) {
            this.compact(writeBuffer);
        }
        this.channel.force(false);
    }

    private void compact(ByteBuffer writeBuffer) throws IOException {
        int nBytes;
        assert (this.stackPosition <= this.initialPosition);
        if (this.initialPosition == this.stackPosition) {
            return;
        }
        long writePosition = this.stackPosition;
        long readPosition = this.initialPosition;
        do {
            writeBuffer.clear();
            this.channel.position(readPosition);
            nBytes = this.channel.read(writeBuffer);
            if (nBytes <= 0) continue;
            readPosition += (long)nBytes;
            writeBuffer.flip();
            this.channel.position(writePosition);
            this.channel.writeAll(writeBuffer);
            writePosition += (long)nBytes;
        } while (nBytes > 0);
        this.channel.truncate(writePosition);
    }
}

