/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.IOException;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReader;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.StorageEntityCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.unsafe.impl.batchimport.input.InputChunk;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityVisitor;

abstract class StoreScanChunk<T extends StorageEntityCursor>
implements InputChunk {
    protected final StoragePropertyCursor storePropertyCursor;
    private final EntityType entityType;
    protected final T cursor;
    private final boolean requiresPropertyMigration;
    private long id;
    private long endId;

    StoreScanChunk(T cursor, RecordStorageReader storageReader, boolean requiresPropertyMigration, EntityType entityType) {
        this.cursor = cursor;
        this.requiresPropertyMigration = requiresPropertyMigration;
        this.storePropertyCursor = storageReader.allocatePropertyCursor();
        this.entityType = entityType;
    }

    void visitProperties(T record, InputEntityVisitor visitor) {
        if (!this.requiresPropertyMigration) {
            visitor.propertyId(record.propertiesReference());
        } else {
            this.storePropertyCursor.init(record.propertiesReference(), record.entityReference(), this.entityType);
            while (this.storePropertyCursor.next()) {
                visitor.property(this.storePropertyCursor.propertyKey(), this.storePropertyCursor.propertyValue().asObject());
            }
            this.storePropertyCursor.close();
        }
    }

    @Override
    public void close() {
        this.storePropertyCursor.close();
    }

    @Override
    public boolean next(InputEntityVisitor visitor) throws IOException {
        if (this.id < this.endId) {
            this.read(this.cursor, this.id);
            if (this.cursor.next()) {
                this.visitRecord(this.cursor, visitor);
                visitor.endOfEntity();
            }
            ++this.id;
            return true;
        }
        return false;
    }

    protected abstract void read(T var1, long var2);

    public void initialize(long startId, long endId) {
        this.id = startId;
        this.endId = endId;
    }

    abstract void visitRecord(T var1, InputEntityVisitor var2);
}

