/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionFactory;
import org.neo4j.kernel.api.security.AnonymousContext;

class TransactionStatementSequenceTest {
    TransactionStatementSequenceTest() {
    }

    @Test
    void shouldAllowReadStatementAfterReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((LoginContext)AnonymousContext.read());
        tx.dataRead();
        tx.dataRead();
    }

    @Test
    void shouldAllowDataStatementAfterReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((LoginContext)AnonymousContext.write());
        tx.dataRead();
        tx.dataWrite();
    }

    @Test
    void shouldAllowSchemaStatementAfterReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(LoginContext.AUTH_DISABLED);
        tx.dataRead();
        tx.schemaWrite();
    }

    @Test
    void shouldRejectSchemaStatementAfterDataStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(LoginContext.AUTH_DISABLED);
        tx.dataWrite();
        InvalidTransactionTypeKernelException exception = (InvalidTransactionTypeKernelException)Assertions.assertThrows(InvalidTransactionTypeKernelException.class, () -> ((KernelTransaction)tx).schemaWrite());
        Assertions.assertEquals((Object)"Cannot perform schema updates in a transaction that has performed data updates.", (Object)exception.getMessage());
    }

    @Test
    void shouldRejectDataStatementAfterSchemaStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(LoginContext.AUTH_DISABLED);
        tx.schemaWrite();
        InvalidTransactionTypeKernelException exception = (InvalidTransactionTypeKernelException)Assertions.assertThrows(InvalidTransactionTypeKernelException.class, () -> ((KernelTransaction)tx).dataWrite());
        Assertions.assertEquals((Object)"Cannot perform data updates in a transaction that has performed schema updates.", (Object)exception.getMessage());
    }

    @Test
    void shouldAllowDataStatementAfterDataStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((LoginContext)AnonymousContext.write());
        tx.dataWrite();
        tx.dataWrite();
    }

    @Test
    void shouldAllowSchemaStatementAfterSchemaStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(LoginContext.AUTH_DISABLED);
        tx.schemaWrite();
        tx.schemaWrite();
    }

    @Test
    void shouldAllowReadStatementAfterDataStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((LoginContext)AnonymousContext.write());
        tx.dataWrite();
        tx.dataRead();
    }

    @Test
    void shouldAllowReadStatementAfterSchemaStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(LoginContext.AUTH_DISABLED);
        tx.schemaWrite();
        tx.dataRead();
    }
}

