/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.collection.Dependencies;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.function.IOFunction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategies;
import org.neo4j.kernel.extension.context.DatabaseExtensionContext;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.fusion.NativeLuceneFusionIndexProviderFactory30;
import org.neo4j.kernel.impl.pagecache.ConfigurableStandalonePageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.concurrent.ThreadingRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

@RunWith(value=Parameterized.class)
public class DatabaseCompositeIndexAccessorTest {
    private static final int PROP_ID1 = 1;
    private static final int PROP_ID2 = 2;
    private static final Config CONFIG = Config.defaults();
    private static final IndexSamplingConfig SAMPLING_CONFIG = new IndexSamplingConfig(CONFIG);
    @Rule
    public final ThreadingRule threading = new ThreadingRule();
    private static final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private static final TestDirectory dir = TestDirectory.testDirectory(DatabaseCompositeIndexAccessorTest.class, (FileSystemAbstraction)fileSystemRule);
    private static final CleanupRule cleanup = new CleanupRule();
    private static final AssertableLogProvider logProvider = new AssertableLogProvider();
    @ClassRule
    public static final RuleChain rules = RuleChain.outerRule((TestRule)fileSystemRule).around((TestRule)dir).around((TestRule)cleanup).around((TestRule)logProvider);
    @Parameterized.Parameter(value=0)
    public String testName;
    @Parameterized.Parameter(value=1)
    public IOFunction<DirectoryFactory, IndexAccessor> accessorFactory;
    private IndexAccessor accessor;
    private final long nodeId = 1L;
    private final long nodeId2 = 2L;
    private final Object[] values = new Object[]{"value1", "values2"};
    private final Object[] values2 = new Object[]{40, 42};
    private DirectoryFactory.InMemoryDirectoryFactory dirFactory;
    private static final IndexPrototype SCHEMA_INDEX_DESCRIPTOR = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{1, 2}));
    private static final IndexPrototype UNIQUE_SCHEMA_INDEX_DESCRIPTOR = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{1, 2}));

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> implementations() throws IOException {
        List<ExtensionFactory> indexProviderFactories = Arrays.asList(new GenericNativeIndexProviderFactory(), new NativeLuceneFusionIndexProviderFactory30());
        Dependencies deps = new Dependencies();
        JobScheduler jobScheduler = (JobScheduler)cleanup.add((AutoCloseable)JobSchedulerFactory.createInitialisedScheduler());
        PageCache pageCache = (PageCache)cleanup.add((AutoCloseable)ConfigurableStandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystemRule, (JobScheduler)jobScheduler));
        deps.satisfyDependencies(new Object[]{pageCache, jobScheduler, fileSystemRule, new SimpleLogService((LogProvider)logProvider), new Monitors(), CONFIG, RecoveryCleanupWorkCollector.ignore()});
        dir.prepareDirectory(DatabaseCompositeIndexAccessorTest.class, "null");
        Config config = Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (Object)dir.homeDir().toPath());
        DatabaseExtensionContext context = new DatabaseExtensionContext(DatabaseLayout.of((Config)config), DatabaseInfo.UNKNOWN, (DependencySatisfier)deps);
        DatabaseExtensions extensions = new DatabaseExtensions(context, indexProviderFactories, deps, ExtensionFailureStrategies.fail());
        extensions.init();
        Iterable providers = deps.resolveTypeDependencies(IndexProvider.class);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (IndexProvider provider : providers) {
            params.add(DatabaseCompositeIndexAccessorTest.parameterSetup(provider, provider.completeConfiguration(SCHEMA_INDEX_DESCRIPTOR.withName("index_" + params.size()).materialise((long)params.size()))));
            params.add(DatabaseCompositeIndexAccessorTest.parameterSetup(provider, provider.completeConfiguration(UNIQUE_SCHEMA_INDEX_DESCRIPTOR.withName("constraint_" + params.size()).materialise((long)params.size()))));
        }
        return params;
    }

    private static Object[] parameterSetup(IndexProvider provider, IndexDescriptor descriptor) {
        IOFunction function = dirFactory1 -> {
            IndexPopulator populator = provider.getPopulator(descriptor, SAMPLING_CONFIG, ByteBufferFactory.heapBufferFactory((int)1024));
            populator.create();
            populator.close(true);
            return provider.getOnlineAccessor(descriptor, SAMPLING_CONFIG);
        };
        return new Object[]{provider.getClass().getSimpleName() + " / " + descriptor, function};
    }

    @Before
    public void before() throws IOException {
        this.dirFactory = new DirectoryFactory.InMemoryDirectoryFactory();
        this.accessor = (IndexAccessor)this.accessorFactory.apply((Object)this.dirFactory);
    }

    @After
    public void after() {
        this.accessor.close();
        this.dirFactory.close();
    }

    @Test
    public void indexReaderShouldSupportScan() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.values), this.add(2L, this.values2)));
        IndexReader reader = this.accessor.newReader();
        Set<Long> results = this.resultSet(reader, new IndexQuery[]{IndexQuery.exists((int)1), IndexQuery.exists((int)2)});
        Set<Long> results2 = this.resultSet(reader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values[0]), IndexQuery.exact((int)2, (Object)this.values[1])});
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), results);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), results2);
        reader.close();
    }

    @Test
    public void multipleIndexReadersFromDifferentPointsInTimeCanSeeDifferentResults() throws Exception {
        this.updateAndCommit(Collections.singletonList(this.add(1L, this.values)));
        IndexReader firstReader = this.accessor.newReader();
        this.updateAndCommit(Collections.singletonList(this.add(2L, this.values2)));
        IndexReader secondReader = this.accessor.newReader();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), this.resultSet(firstReader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values[0]), IndexQuery.exact((int)2, (Object)this.values[1])}));
        Assert.assertThat(this.resultSet(firstReader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values2[0]), IndexQuery.exact((int)2, (Object)this.values2[1])}), (Matcher)Matchers.oneOf((Object[])new Set[]{Iterators.asSet((Object[])new Object[0]), Iterators.asSet((Object[])new Long[]{2L})}));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), this.resultSet(secondReader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values[0]), IndexQuery.exact((int)2, (Object)this.values[1])}));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{2L}), this.resultSet(secondReader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values2[0]), IndexQuery.exact((int)2, (Object)this.values2[1])}));
        firstReader.close();
        secondReader.close();
    }

    @Test
    public void canAddNewData() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.values), this.add(2L, this.values2)));
        IndexReader reader = this.accessor.newReader();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), this.resultSet(reader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values[0]), IndexQuery.exact((int)2, (Object)this.values[1])}));
        reader.close();
    }

    @Test
    public void canChangeExistingData() throws Exception {
        this.updateAndCommit(Collections.singletonList(this.add(1L, this.values)));
        this.updateAndCommit(Collections.singletonList(this.change(1L, this.values, this.values2)));
        IndexReader reader = this.accessor.newReader();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), this.resultSet(reader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values2[0]), IndexQuery.exact((int)2, (Object)this.values2[1])}));
        Assert.assertEquals(Collections.emptySet(), this.resultSet(reader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values[0]), IndexQuery.exact((int)2, (Object)this.values[1])}));
        reader.close();
    }

    @Test
    public void canRemoveExistingData() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.values), this.add(2L, this.values2)));
        this.updateAndCommit(Collections.singletonList(this.remove(1L, this.values)));
        IndexReader reader = this.accessor.newReader();
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{2L}), this.resultSet(reader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values2[0]), IndexQuery.exact((int)2, (Object)this.values2[1])}));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), this.resultSet(reader, new IndexQuery[]{IndexQuery.exact((int)1, (Object)this.values[0]), IndexQuery.exact((int)2, (Object)this.values[1])}));
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void shouldStopSamplingWhenIndexIsDropped() throws Exception {
        this.updateAndCommit(Arrays.asList(this.add(1L, this.values), this.add(2L, this.values2)));
        IndexReader indexReader = this.accessor.newReader();
        IndexSampler indexSampler = indexReader.createSampler();
        AtomicBoolean droppedLatch = new AtomicBoolean();
        AtomicReference dropper = new AtomicReference();
        Predicate awaitCompletion = ThreadingRule.waitingWhileIn(TaskCoordinator.class, (String)"awaitCompletion");
        Future drop = this.threading.execute(nothing -> {
            dropper.set(Thread.currentThread());
            try {
                this.accessor.drop();
            }
            finally {
                droppedLatch.set(true);
            }
            return null;
        }, null);
        try (IndexReader reader = indexReader;
             IndexSampler sampler = indexSampler;){
            while (!droppedLatch.get() && !awaitCompletion.test((Thread)dropper.get())) {
                Thread.onSpinWait();
            }
            sampler.sampleIndex();
            Assert.fail((String)"expected exception");
        }
        catch (IndexNotFoundKernelException e) {
            Assert.assertEquals((Object)"Index dropped while sampling.", (Object)e.getMessage());
        }
        finally {
            drop.get();
        }
    }

    private Set<Long> resultSet(IndexReader reader, IndexQuery ... queries) throws IndexNotApplicableKernelException {
        try (NodeValueIterator results = new NodeValueIterator();){
            reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)results, IndexOrder.NONE, false, queries);
            Set set = PrimitiveLongCollections.toSet((LongIterator)results);
            return set;
        }
    }

    private IndexEntryUpdate<?> add(long nodeId, Object ... values) {
        return IndexQueryHelper.add((long)nodeId, (SchemaDescriptor)SCHEMA_INDEX_DESCRIPTOR.schema(), (Object[])values);
    }

    private IndexEntryUpdate<?> remove(long nodeId, Object ... values) {
        return IndexQueryHelper.remove((long)nodeId, (SchemaDescriptor)SCHEMA_INDEX_DESCRIPTOR.schema(), (Object[])values);
    }

    private IndexEntryUpdate<?> change(long nodeId, Object[] valuesBefore, Object[] valuesAfter) {
        return IndexQueryHelper.change((long)nodeId, (SchemaDescriptor)SCHEMA_INDEX_DESCRIPTOR.schema(), (Object[])valuesBefore, (Object[])valuesAfter);
    }

    private void updateAndCommit(List<IndexEntryUpdate<?>> nodePropertyUpdates) throws IndexEntryConflictException {
        try (IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE);){
            for (IndexEntryUpdate<?> update : nodePropertyUpdates) {
                updater.process(update);
            }
        }
    }
}

