/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.PropertyKeyValue;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StubStorageCursors;
import org.neo4j.token.api.NamedToken;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class EntityUpdatesTest {
    private static final long nodeId = 0L;
    private static final int labelId1 = 0;
    private static final int labelId2 = 1;
    private static final int unusedLabelId = 2;
    private static final int propertyKeyId1 = 0;
    private static final int propertyKeyId2 = 1;
    private static final int propertyKeyId3 = 2;
    private static final long[] label = new long[]{0L};
    private static final long[] allLabels = new long[]{0L, 1L};
    private static final long[] empty = new long[0];
    private static final LabelSchemaDescriptor index1 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{0});
    private static final LabelSchemaDescriptor index2 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{1});
    private static final LabelSchemaDescriptor index3 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{2});
    private static final LabelSchemaDescriptor index123 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{0, 1, 2});
    private static final List<LabelSchemaDescriptor> indexes = Arrays.asList(index1, index2, index3, index123);
    private static final SchemaDescriptor nonSchemaIndex = SchemaDescriptor.fulltext((EntityType)EntityType.NODE, (int[])new int[]{0, 1}, (int[])new int[]{0, 1, 2});
    private static final StorageProperty property1 = new PropertyKeyValue(0, Values.of((Object)"Neo"));
    private static final StorageProperty property2 = new PropertyKeyValue(1, Values.of((Object)100L));
    private static final StorageProperty property3 = new PropertyKeyValue(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6}));
    private static final Value[] values123 = new Value[]{property1.value(), property2.value(), property3.value()};

    EntityUpdatesTest() {
    }

    @Test
    void shouldNotGenerateUpdatesForEmptyNodeUpdates() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, EntityUpdatesTest.assertNoLoading(), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    void shouldNotGenerateUpdateForMultipleExistingPropertiesAndLabels() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).existing(0, Values.of((Object)"Neo")).existing(1, Values.of((Object)100L)).existing(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, EntityUpdatesTest.assertNoLoading(), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    void shouldNotGenerateUpdatesForLabelAdditionWithNoProperties() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).withTokensAfter(label).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(new StorageProperty[0]), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    void shouldGenerateUpdateForLabelAdditionWithExistingProperty() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).withTokensAfter(label).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(property1), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()})}));
    }

    @Test
    void shouldGenerateUpdatesForLabelAdditionWithExistingProperties() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).withTokensAfter(label).existing(0, Values.of((Object)"Neo")).existing(1, Values.of((Object)100L)).existing(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index2, (Value[])new Value[]{property2.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index3, (Value[])new Value[]{property3.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)}));
    }

    @Test
    void shouldNotGenerateUpdateForPartialCompositeSchemaIndexUpdate() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).added(0, Values.of((Object)"Neo")).added(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(index123), EntityUpdatesTest.propertyLoader(new StorageProperty[0]), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    void shouldGenerateUpdateForWhenCompletingCompositeSchemaIndexUpdate() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).added(0, Values.of((Object)"Neo")).added(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(index123), EntityUpdatesTest.propertyLoader(property2), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)}));
    }

    @Test
    void shouldNotGenerateUpdatesForLabelRemovalWithNoProperties() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(empty).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(new StorageProperty[0]), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    void shouldGenerateUpdateForLabelRemovalWithExistingProperty() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(empty).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(property1), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()})}));
    }

    @Test
    void shouldGenerateUpdatesForLabelRemovalWithExistingProperties() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(empty).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index2, (Value[])new Value[]{property2.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index3, (Value[])new Value[]{property3.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)}));
    }

    @Test
    void shouldNotGenerateUpdatesForPropertyAdditionWithNoLabels() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).added(property1.propertyKeyId(), property1.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, EntityUpdatesTest.assertNoLoading(), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    void shouldGenerateUpdatesForSinglePropertyAdditionWithLabels() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).added(property1.propertyKeyId(), property1.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(new StorageProperty[0]), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()})}));
    }

    @Test
    void shouldGenerateUpdatesForMultiplePropertyAdditionWithLabels() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).added(property1.propertyKeyId(), property1.value()).added(property2.propertyKeyId(), property2.value()).added(property3.propertyKeyId(), property3.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index1, (Value[])new Value[]{property1.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index2, (Value[])new Value[]{property2.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index3, (Value[])new Value[]{property3.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)index123, (Value[])values123)}));
    }

    @Test
    void shouldNotGenerateUpdatesForLabelAddAndPropertyRemove() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).withTokensAfter(label).removed(property1.propertyKeyId(), property1.value()).removed(property2.propertyKeyId(), property2.value()).removed(property3.propertyKeyId(), property3.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, EntityUpdatesTest.assertNoLoading(), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    void shouldNotGenerateUpdatesForLabelRemoveAndPropertyAdd() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(empty).added(property1.propertyKeyId(), property1.value()).added(property2.propertyKeyId(), property2.value()).added(property3.propertyKeyId(), property3.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(indexes, EntityUpdatesTest.assertNoLoading(), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    void shouldNotLoadPropertyForLabelsAndNoPropertyChanges() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(index1), EntityUpdatesTest.assertNoLoading(), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    void shouldNotLoadPropertyForNoLabelsAndButPropertyAddition() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).added(property1.propertyKeyId(), property1.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(index1), EntityUpdatesTest.assertNoLoading(), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    void shouldGenerateUpdateForPartialNonSchemaIndexUpdate() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).added(0, Values.of((Object)"Neo")).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(new StorageProperty[0]), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])new Value[]{property1.value(), null, null})}));
    }

    @Test
    void shouldGenerateUpdateForFullNonSchemaIndexUpdate() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).added(property1.propertyKeyId(), property1.value()).added(property2.propertyKeyId(), property2.value()).added(property3.propertyKeyId(), property3.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(new StorageProperty[0]), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)}));
    }

    @Test
    void shouldGenerateUpdateForSingleChangeNonSchemaIndex() {
        Value newValue2 = Values.of((Object)10L);
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).changed(property2.propertyKeyId(), property2.value(), newValue2).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123, (Value[])new Value[]{property1.value(), newValue2, property3.value()})}));
    }

    @Test
    void shouldGenerateUpdateForAllChangedNonSchemaIndex() {
        Value newValue1 = Values.of((Object)"Nio");
        Value newValue2 = Values.of((Object)10L);
        PointValue newValue3 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{32.3, 15.6});
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).changed(property1.propertyKeyId(), property1.value(), newValue1).changed(property2.propertyKeyId(), property2.value(), newValue2).changed(property3.propertyKeyId(), property3.value(), (Value)newValue3).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123, (Value[])new Value[]{newValue1, newValue2, newValue3})}));
    }

    @Test
    void shouldGenerateUpdateWhenRemovingLastPropForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).removed(property2.propertyKeyId(), property2.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property2), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])new Value[]{null, property2.value(), null})}));
    }

    @Test
    void shouldGenerateUpdateWhenRemovingOnePropertyForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(label).removed(property2.propertyKeyId(), property2.value()).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123, (Value[])new Value[]{property1.value(), null, property3.value()})}));
    }

    @Test
    void shouldGenerateUpdateWhenAddingOneTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).withTokensAfter(label).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)}));
    }

    @Test
    void shouldGenerateUpdateWhenAddingMultipleTokensForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(empty).withTokensAfter(allLabels).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)}));
    }

    @Test
    void shouldNotGenerateUpdateWhenAddingAnotherTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(allLabels).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    void shouldNotGenerateUpdateWhenAddingAnotherUselessTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(new long[]{0L, 2L}).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    void shouldGenerateUpdateWhenSwitchingToUselessTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(new long[]{2L}).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)}));
    }

    @Test
    void shouldNotGenerateUpdateWhenRemovingOneTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(allLabels).withTokensAfter(label).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.emptyIterable());
    }

    @Test
    void shouldGenerateUpdateWhenRemovingLastTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(label).withTokensAfter(empty).build();
        MatcherAssert.assertThat((Object)updates.forIndexKeys(Collections.singleton(nonSchemaIndex), EntityUpdatesTest.propertyLoader(property1, property2, property3), EntityType.NODE), (Matcher)Matchers.containsInAnyOrder((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)nonSchemaIndex, (Value[])values123)}));
    }

    private static StorageReader propertyLoader(StorageProperty ... properties) {
        StubStorageCursors stub = new StubStorageCursors();
        for (StorageProperty property : properties) {
            stub.propertyKeyTokenHolder().addToken(new NamedToken(String.valueOf(property.propertyKeyId()), property.propertyKeyId()));
        }
        HashMap<String, Value> propertyMap = new HashMap<String, Value>();
        for (StorageProperty p : properties) {
            propertyMap.put(String.valueOf(p.propertyKeyId()), p.value());
        }
        stub.withNode(0L).properties(propertyMap);
        return stub;
    }

    private static StorageReader assertNoLoading() {
        StorageReader reader = (StorageReader)Mockito.mock(StorageReader.class);
        IllegalStateException exception = new IllegalStateException("Should never attempt to load properties!");
        Mockito.when((Object)reader.allocateNodeCursor()).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)reader.allocateRelationshipScanCursor()).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)reader.allocateRelationshipTraversalCursor()).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)reader.allocateRelationshipGroupCursor()).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)reader.allocatePropertyCursor()).thenThrow(new Throwable[]{exception});
        return reader;
    }
}

