/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaTestUtil;

class SchemaDescriptorTest {
    private static final int REL_TYPE_ID = 0;
    private static final int LABEL_ID = 0;

    SchemaDescriptorTest() {
    }

    @Test
    void shouldCreateLabelDescriptors() {
        LabelSchemaDescriptor labelDesc = SchemaDescriptor.forLabel((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)labelDesc.getLabelId(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)labelDesc.entityType(), (Matcher)Matchers.is((Object)EntityType.NODE));
        MatcherAssert.assertThat((Object)labelDesc.propertySchemaType(), (Matcher)Matchers.is((Object)PropertySchemaType.COMPLETE_ALL_TOKENS));
        SchemaTestUtil.assertArray(labelDesc.getPropertyIds(), 1);
        labelDesc = SchemaDescriptor.forLabel((int)0, (int[])new int[]{1, 2, 3});
        MatcherAssert.assertThat((Object)labelDesc.getLabelId(), (Matcher)Matchers.equalTo((Object)0));
        SchemaTestUtil.assertArray(labelDesc.getPropertyIds(), 1, 2, 3);
    }

    @Test
    void shouldCreateRelTypeDescriptors() {
        RelationTypeSchemaDescriptor relTypeDesc = SchemaDescriptor.forRelType((int)0, (int[])new int[]{1});
        MatcherAssert.assertThat((Object)relTypeDesc.getRelTypeId(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)relTypeDesc.entityType(), (Matcher)Matchers.is((Object)EntityType.RELATIONSHIP));
        MatcherAssert.assertThat((Object)relTypeDesc.propertySchemaType(), (Matcher)Matchers.is((Object)PropertySchemaType.COMPLETE_ALL_TOKENS));
        SchemaTestUtil.assertArray(relTypeDesc.getPropertyIds(), 1);
        relTypeDesc = SchemaDescriptor.forRelType((int)0, (int[])new int[]{1, 2, 3});
        MatcherAssert.assertThat((Object)relTypeDesc.getRelTypeId(), (Matcher)Matchers.equalTo((Object)0));
        SchemaTestUtil.assertArray(relTypeDesc.getPropertyIds(), 1, 2, 3);
    }

    @Test
    void shouldCreateEqualLabels() {
        LabelSchemaDescriptor desc1 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{1});
        LabelSchemaDescriptor desc2 = SchemaDescriptor.forLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
    }

    @Test
    void shouldCreateEqualRelTypes() {
        RelationTypeSchemaDescriptor desc1 = SchemaDescriptor.forRelType((int)0, (int[])new int[]{1});
        RelationTypeSchemaDescriptor desc2 = SchemaDescriptor.forRelType((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1, desc2);
    }

    @Test
    void shouldGiveNiceUserDescriptions() {
        MatcherAssert.assertThat((Object)SchemaDescriptor.forLabel((int)1, (int[])new int[]{2}).userDescription(SchemaTestUtil.SIMPLE_NAME_LOOKUP), (Matcher)Matchers.equalTo((Object)":Label1(property2)"));
        MatcherAssert.assertThat((Object)SchemaDescriptor.forRelType((int)1, (int[])new int[]{3}).userDescription(SchemaTestUtil.SIMPLE_NAME_LOOKUP), (Matcher)Matchers.equalTo((Object)"-[:RelType1(property3)]-"));
    }
}

