/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TestableTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.storageengine.api.CommandsToApply;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionIdStore;

class TransactionRepresentationCommitProcessTest {
    private final CommitEvent commitEvent = CommitEvent.NULL;

    TransactionRepresentationCommitProcessTest() {
    }

    @Test
    void shouldFailWithProperMessageOnAppendException() throws Exception {
        TransactionAppender appender = (TransactionAppender)Mockito.mock(TransactionAppender.class);
        IOException rootCause = new IOException("Mock exception");
        ((TransactionAppender)Mockito.doThrow((Throwable[])new Throwable[]{new IOException(rootCause)}).when((Object)appender)).append((TransactionToApply)ArgumentMatchers.any(TransactionToApply.class), (LogAppendEvent)ArgumentMatchers.any(LogAppendEvent.class));
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        TransactionRepresentationCommitProcess commitProcess = new TransactionRepresentationCommitProcess(appender, storageEngine);
        TransactionFailureException exception = (TransactionFailureException)Assertions.assertThrows(TransactionFailureException.class, () -> this.lambda$shouldFailWithProperMessageOnAppendException$0((TransactionCommitProcess)commitProcess));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not append transaction representation to log"));
        Assertions.assertTrue((boolean)Exceptions.contains((Throwable)exception, (String)rootCause.getMessage(), (Class[])new Class[]{rootCause.getClass()}));
    }

    @Test
    void shouldCloseTransactionRegardlessOfWhetherOrNotItAppliedCorrectly() throws Exception {
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        TestableTransactionAppender appender = new TestableTransactionAppender(transactionIdStore);
        long txId = 11L;
        Mockito.when((Object)transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)txId);
        IOException rootCause = new IOException("Mock exception");
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        ((StorageEngine)Mockito.doThrow((Throwable[])new Throwable[]{new IOException(rootCause)}).when((Object)storageEngine)).apply((CommandsToApply)ArgumentMatchers.any(TransactionToApply.class), (TransactionApplicationMode)ArgumentMatchers.any(TransactionApplicationMode.class));
        TransactionRepresentationCommitProcess commitProcess = new TransactionRepresentationCommitProcess((TransactionAppender)appender, storageEngine);
        TransactionToApply transaction = this.mockedTransaction();
        TransactionFailureException exception = (TransactionFailureException)Assertions.assertThrows(TransactionFailureException.class, () -> this.lambda$shouldCloseTransactionRegardlessOfWhetherOrNotItAppliedCorrectly$1((TransactionCommitProcess)commitProcess, transaction));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not apply the transaction to the store"));
        Assertions.assertTrue((boolean)Exceptions.contains((Throwable)exception, (String)rootCause.getMessage(), (Class[])new Class[]{rootCause.getClass()}));
        ((TransactionIdStore)Mockito.verify((Object)transactionIdStore)).transactionClosed(ArgumentMatchers.eq((long)txId), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
    }

    @Test
    void shouldSuccessfullyCommitTransactionWithNoCommands() throws Exception {
        long txId = 11L;
        long commitTimestamp = System.currentTimeMillis();
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        TestableTransactionAppender appender = new TestableTransactionAppender(transactionIdStore);
        Mockito.when((Object)transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)txId);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        TransactionRepresentationCommitProcess commitProcess = new TransactionRepresentationCommitProcess((TransactionAppender)appender, storageEngine);
        PhysicalTransactionRepresentation noCommandTx = new PhysicalTransactionRepresentation(Collections.emptyList());
        noCommandTx.setHeader(new byte[0], -1L, -1L, -1L, -1);
        commitProcess.commit(new TransactionToApply((TransactionRepresentation)noCommandTx), this.commitEvent, TransactionApplicationMode.INTERNAL);
        ((TransactionIdStore)Mockito.verify((Object)transactionIdStore)).transactionCommitted(txId, 3, 8194639457389L);
    }

    private TransactionToApply mockedTransaction() {
        TransactionRepresentation transaction = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        Mockito.when((Object)transaction.additionalHeader()).thenReturn((Object)new byte[0]);
        return new TransactionToApply(transaction);
    }

    private /* synthetic */ void lambda$shouldCloseTransactionRegardlessOfWhetherOrNotItAppliedCorrectly$1(TransactionCommitProcess commitProcess, TransactionToApply transaction) throws Throwable {
        commitProcess.commit(transaction, this.commitEvent, TransactionApplicationMode.INTERNAL);
    }

    private /* synthetic */ void lambda$shouldFailWithProperMessageOnAppendException$0(TransactionCommitProcess commitProcess) throws Throwable {
        commitProcess.commit(this.mockedTransaction(), this.commitEvent, TransactionApplicationMode.INTERNAL);
    }
}

