/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.Callable;
import java.util.function.IntPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.EntityType;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.kernel.api.exceptions.index.FlipFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;

class MultipleIndexPopulatorTest {
    private final LabelSchemaDescriptor index1 = SchemaDescriptor.forLabel((int)1, (int[])new int[]{1});
    private IndexStoreView indexStoreView;
    private SchemaState schemaState;
    private MultipleIndexPopulator multipleIndexPopulator;
    private IndexStatisticsStore indexStatisticsStore;

    MultipleIndexPopulatorTest() {
    }

    @BeforeEach
    void before() {
        this.indexStatisticsStore = (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class);
        this.indexStoreView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
        Mockito.when((Object)this.indexStoreView.newPropertyAccessor()).thenReturn((Object)((NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class)));
        Mockito.when((Object)this.indexStoreView.visitNodes((int[])ArgumentMatchers.any(), (IntPredicate)ArgumentMatchers.any(), (Visitor)ArgumentMatchers.any(), (Visitor)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)((StoreScan)Mockito.mock(StoreScan.class)));
        this.schemaState = (SchemaState)Mockito.mock(SchemaState.class);
        this.multipleIndexPopulator = new MultipleIndexPopulator(this.indexStoreView, (LogProvider)NullLogProvider.getInstance(), EntityType.NODE, this.schemaState, this.indexStatisticsStore);
    }

    @Test
    void canceledPopulationNotAbleToCreateNewIndex() throws FlipFailedKernelException {
        IndexPopulator populator = MultipleIndexPopulatorTest.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation indexPopulation = this.addPopulator(populator, 1);
        indexPopulation.cancel();
        this.multipleIndexPopulator.create();
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).create();
    }

    @Test
    void canceledPopulationNotAbleToFlip() throws FlipFailedKernelException {
        IndexPopulator populator = MultipleIndexPopulatorTest.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation indexPopulation = this.addPopulator(populator, 1);
        indexPopulation.cancel();
        indexPopulation.flip(false);
        ((IndexPopulator)Mockito.verify((Object)indexPopulation.populator, (VerificationMode)Mockito.never())).sampleResult();
    }

    @Test
    void flippedPopulationAreNotCanceable() throws FlipFailedKernelException {
        IndexPopulator populator = MultipleIndexPopulatorTest.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation indexPopulation = this.addPopulator(populator, 1);
        indexPopulation.flip(false);
        indexPopulation.cancel();
        ((IndexPopulator)Mockito.verify((Object)indexPopulation.populator, (VerificationMode)Mockito.never())).close(false);
    }

    @Test
    void cancelAndDropShouldCallDropOnPopulator() throws FlipFailedKernelException {
        IndexPopulator populator = MultipleIndexPopulatorTest.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation indexPopulation = this.addPopulator(populator, 1);
        indexPopulation.cancelAndDrop();
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).close(false);
        ((IndexPopulator)Mockito.verify((Object)populator)).drop();
    }

    @Test
    void testMultiplePopulatorsCreation() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.create();
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).create();
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).create();
    }

    @Test
    void testMultiplePopulatorCreationFailure() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator3 = MultipleIndexPopulatorTest.createIndexPopulator();
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{MultipleIndexPopulatorTest.getPopulatorException()}).when((Object)indexPopulator1)).create();
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{MultipleIndexPopulatorTest.getPopulatorException()}).when((Object)indexPopulator3)).create();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.addPopulator(indexPopulator3, 3);
        this.multipleIndexPopulator.create();
        MultipleIndexPopulatorTest.checkPopulatorFailure(indexPopulator1);
        MultipleIndexPopulatorTest.checkPopulatorFailure(indexPopulator3);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).create();
    }

    @Test
    void testHasPopulators() throws FlipFailedKernelException {
        Assertions.assertFalse((boolean)this.multipleIndexPopulator.hasPopulators());
        this.addPopulator(MultipleIndexPopulatorTest.createIndexPopulator(), 42);
        Assertions.assertTrue((boolean)this.multipleIndexPopulator.hasPopulators());
    }

    @Test
    void cancelingSinglePopulatorDoNotCancelAnyOther() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation populationToCancel = this.addPopulator(indexPopulator1, 1);
        MultipleIndexPopulator.IndexPopulation populationToKeepActive = this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.create();
        this.multipleIndexPopulator.cancelIndexPopulation(populationToCancel);
        this.multipleIndexPopulator.indexAllEntities();
        Assertions.assertTrue((boolean)this.multipleIndexPopulator.hasPopulators());
        this.multipleIndexPopulator.flipAfterPopulation(false);
        ((FlippableIndexProxy)Mockito.verify((Object)populationToKeepActive.flipper)).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
    }

    @Test
    void canceledPopulatorDoNotFlipWhenPopulationCompleted() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation populationToCancel = this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.create();
        this.multipleIndexPopulator.cancelIndexPopulation(populationToCancel);
        this.multipleIndexPopulator.indexAllEntities();
        Assertions.assertTrue((boolean)this.multipleIndexPopulator.hasPopulators());
        this.multipleIndexPopulator.flipAfterPopulation(false);
        ((FlippableIndexProxy)Mockito.verify((Object)populationToCancel.flipper, (VerificationMode)Mockito.never())).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
    }

    @Test
    void testIndexAllNodes() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.create();
        this.multipleIndexPopulator.indexAllEntities();
        ((IndexStoreView)Mockito.verify((Object)this.indexStoreView)).visitNodes((int[])ArgumentMatchers.any(int[].class), (IntPredicate)ArgumentMatchers.any(IntPredicate.class), (Visitor)ArgumentMatchers.any(Visitor.class), (Visitor)ArgumentMatchers.isNull(), ArgumentMatchers.anyBoolean());
    }

    @Test
    void testFailPopulator() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.fail((Throwable)MultipleIndexPopulatorTest.getPopulatorException());
        MultipleIndexPopulatorTest.checkPopulatorFailure(indexPopulator1);
        MultipleIndexPopulatorTest.checkPopulatorFailure(indexPopulator2);
    }

    @Test
    void testFailByPopulation() throws FlipFailedKernelException {
        IndexPopulator populator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator populator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(populator1, 1);
        MultipleIndexPopulator.IndexPopulation population2 = this.addPopulator(populator2, 2);
        this.multipleIndexPopulator.fail(population2, (Throwable)MultipleIndexPopulatorTest.getPopulatorException());
        ((IndexPopulator)Mockito.verify((Object)populator1, (VerificationMode)Mockito.never())).markAsFailed(ArgumentMatchers.anyString());
        MultipleIndexPopulatorTest.checkPopulatorFailure(populator2);
    }

    @Test
    void testFailByPopulationRemovesPopulator() throws FlipFailedKernelException {
        IndexPopulator populator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator populator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        MultipleIndexPopulator.IndexPopulation population1 = this.addPopulator(populator1, 1);
        MultipleIndexPopulator.IndexPopulation population2 = this.addPopulator(populator2, 2);
        this.multipleIndexPopulator.fail(population1, (Throwable)MultipleIndexPopulatorTest.getPopulatorException());
        this.multipleIndexPopulator.fail(population2, (Throwable)MultipleIndexPopulatorTest.getPopulatorException());
        MultipleIndexPopulatorTest.checkPopulatorFailure(populator1);
        MultipleIndexPopulatorTest.checkPopulatorFailure(populator2);
        Assertions.assertFalse((boolean)this.multipleIndexPopulator.hasPopulators());
    }

    @Test
    void testFailByNonExistingPopulation() throws FlipFailedKernelException {
        MultipleIndexPopulator.IndexPopulation nonExistingPopulation = (MultipleIndexPopulator.IndexPopulation)Mockito.mock(MultipleIndexPopulator.IndexPopulation.class);
        IndexPopulator populator = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(populator, 1);
        this.multipleIndexPopulator.fail(nonExistingPopulation, (Throwable)MultipleIndexPopulatorTest.getPopulatorException());
        ((IndexPopulator)Mockito.verify((Object)populator, (VerificationMode)Mockito.never())).markAsFailed(ArgumentMatchers.anyString());
    }

    @Test
    void testFlipAfterPopulation() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        FlippableIndexProxy flipper1 = this.addPopulator((IndexPopulator)indexPopulator1, (int)1).flipper;
        FlippableIndexProxy flipper2 = this.addPopulator((IndexPopulator)indexPopulator2, (int)2).flipper;
        this.multipleIndexPopulator.flipAfterPopulation(false);
        ((FlippableIndexProxy)Mockito.verify((Object)flipper1)).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
        ((FlippableIndexProxy)Mockito.verify((Object)flipper2)).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
    }

    @Test
    void populationsRemovedDuringFlip() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        Assertions.assertTrue((boolean)this.multipleIndexPopulator.hasPopulators());
        this.multipleIndexPopulator.flipAfterPopulation(false);
        Assertions.assertFalse((boolean)this.multipleIndexPopulator.hasPopulators());
    }

    @Test
    void testCancelPopulation() throws FlipFailedKernelException {
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        this.multipleIndexPopulator.cancel();
        ((IndexStatisticsStore)Mockito.verify((Object)this.indexStatisticsStore, (VerificationMode)Mockito.times((int)2))).replaceStats(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)0L));
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).close(false);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).close(false);
    }

    @Test
    void testIndexFlip() {
        IndexProxyFactory indexProxyFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FailedIndexProxyFactory failedIndexProxyFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(indexProxyFactory);
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator();
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1, flipper, failedIndexProxyFactory);
        this.addPopulator(indexPopulator2, 2, flipper, failedIndexProxyFactory);
        Mockito.when((Object)indexPopulator1.sampleResult()).thenThrow(new Throwable[]{MultipleIndexPopulatorTest.getSampleError()});
        this.multipleIndexPopulator.indexAllEntities();
        this.multipleIndexPopulator.flipAfterPopulation(false);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator1)).close(false);
        ((FailedIndexProxyFactory)Mockito.verify((Object)failedIndexProxyFactory)).create((Throwable)ArgumentMatchers.any(RuntimeException.class));
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).close(true);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator2)).sampleResult();
        ((IndexStatisticsStore)Mockito.verify((Object)this.indexStatisticsStore)).replaceStats(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        ((SchemaState)Mockito.verify((Object)this.schemaState)).clear();
    }

    @Test
    void testMultiplePopulatorUpdater() throws IndexEntryConflictException, FlipFailedKernelException {
        IndexUpdater indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator(indexUpdater1);
        IndexPopulator indexPopulator2 = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator1, 1);
        this.addPopulator(indexPopulator2, 2);
        ((IndexPopulator)Mockito.doThrow((Throwable[])new Throwable[]{MultipleIndexPopulatorTest.getPopulatorException()}).when((Object)indexPopulator2)).newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any(NodePropertyAccessor.class));
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater((NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class));
        IndexEntryUpdate<?> propertyUpdate = MultipleIndexPopulatorTest.createIndexEntryUpdate(this.index1);
        multipleIndexUpdater.process(propertyUpdate);
        MultipleIndexPopulatorTest.checkPopulatorFailure(indexPopulator2);
        ((IndexUpdater)Mockito.verify((Object)indexUpdater1)).process(propertyUpdate);
    }

    @Test
    void testNonApplicableUpdaterDoNotUpdatePopulator() throws IndexEntryConflictException, FlipFailedKernelException {
        IndexUpdater indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator(indexUpdater1);
        this.addPopulator(indexPopulator1, 2);
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater((NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class));
        IndexEntryUpdate<?> propertyUpdate = MultipleIndexPopulatorTest.createIndexEntryUpdate(this.index1);
        multipleIndexUpdater.process(propertyUpdate);
        Mockito.verifyZeroInteractions((Object[])new Object[]{indexUpdater1});
    }

    @Test
    void testPropertyUpdateFailure() throws IndexEntryConflictException, FlipFailedKernelException {
        IndexEntryUpdate<?> propertyUpdate = MultipleIndexPopulatorTest.createIndexEntryUpdate(this.index1);
        IndexUpdater indexUpdater1 = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator indexPopulator1 = MultipleIndexPopulatorTest.createIndexPopulator(indexUpdater1);
        this.addPopulator(indexPopulator1, 1);
        ((IndexUpdater)Mockito.doThrow((Throwable[])new Throwable[]{MultipleIndexPopulatorTest.getPopulatorException()}).when((Object)indexUpdater1)).process(propertyUpdate);
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater((NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class));
        multipleIndexUpdater.process(propertyUpdate);
        ((IndexUpdater)Mockito.verify((Object)indexUpdater1)).close();
        MultipleIndexPopulatorTest.checkPopulatorFailure(indexPopulator1);
    }

    @Test
    void testMultiplePropertyUpdateFailures() throws IndexEntryConflictException, FlipFailedKernelException {
        NodePropertyAccessor nodePropertyAccessor = (NodePropertyAccessor)Mockito.mock(NodePropertyAccessor.class);
        IndexEntryUpdate update1 = IndexQueryHelper.add((long)1L, (SchemaDescriptor)this.index1, (Object[])new Object[]{"foo"});
        IndexEntryUpdate update2 = IndexQueryHelper.add((long)2L, (SchemaDescriptor)this.index1, (Object[])new Object[]{"bar"});
        IndexUpdater updater = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexPopulator populator = MultipleIndexPopulatorTest.createIndexPopulator(updater);
        this.addPopulator(populator, 1);
        ((IndexUpdater)Mockito.doThrow((Throwable[])new Throwable[]{MultipleIndexPopulatorTest.getPopulatorException()}).when((Object)updater)).process((IndexEntryUpdate)ArgumentMatchers.any(IndexEntryUpdate.class));
        MultipleIndexPopulator.MultipleIndexUpdater multipleIndexUpdater = this.multipleIndexPopulator.newPopulatingUpdater(nodePropertyAccessor);
        multipleIndexUpdater.process(update1);
        multipleIndexUpdater.process(update2);
        ((IndexUpdater)Mockito.verify((Object)updater)).process(update1);
        ((IndexUpdater)Mockito.verify((Object)updater, (VerificationMode)Mockito.never())).process(update2);
        ((IndexUpdater)Mockito.verify((Object)updater)).close();
        MultipleIndexPopulatorTest.checkPopulatorFailure(populator);
    }

    @Test
    void shouldVerifyConstraintsBeforeFlippingIfToldTo() throws IndexEntryConflictException {
        IndexProxyFactory indexProxyFactory = (IndexProxyFactory)Mockito.mock(IndexProxyFactory.class);
        FailedIndexProxyFactory failedIndexProxyFactory = (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class);
        FlippableIndexProxy flipper = new FlippableIndexProxy();
        flipper.setFlipTarget(indexProxyFactory);
        IndexPopulator indexPopulator = MultipleIndexPopulatorTest.createIndexPopulator();
        this.addPopulator(indexPopulator, 1, flipper, failedIndexProxyFactory);
        Mockito.when((Object)indexPopulator.sampleResult()).thenReturn((Object)new IndexSample());
        this.multipleIndexPopulator.indexAllEntities();
        this.multipleIndexPopulator.flipAfterPopulation(true);
        ((IndexPopulator)Mockito.verify((Object)indexPopulator)).verifyDeferredConstraints((NodePropertyAccessor)ArgumentMatchers.any(NodePropertyAccessor.class));
        ((IndexPopulator)Mockito.verify((Object)indexPopulator)).close(true);
    }

    private static IndexEntryUpdate<?> createIndexEntryUpdate(LabelSchemaDescriptor schemaDescriptor) {
        return IndexQueryHelper.add((long)1L, (SchemaDescriptor)schemaDescriptor, (Object[])new Object[]{"theValue"});
    }

    private static RuntimeException getSampleError() {
        return new RuntimeException("sample error");
    }

    private static IndexPopulator createIndexPopulator(IndexUpdater indexUpdater) {
        IndexPopulator indexPopulator = MultipleIndexPopulatorTest.createIndexPopulator();
        Mockito.when((Object)indexPopulator.newPopulatingUpdater((NodePropertyAccessor)ArgumentMatchers.any(NodePropertyAccessor.class))).thenReturn((Object)indexUpdater);
        return indexPopulator;
    }

    private static IndexPopulator createIndexPopulator() {
        IndexPopulator populator = (IndexPopulator)Mockito.mock(IndexPopulator.class);
        Mockito.when((Object)populator.sampleResult()).thenReturn((Object)new IndexSample());
        return populator;
    }

    private static UncheckedIOException getPopulatorException() {
        return new UncheckedIOException(new IOException("something went wrong"));
    }

    private static void checkPopulatorFailure(IndexPopulator populator) {
        ((IndexPopulator)Mockito.verify((Object)populator)).markAsFailed(ArgumentMatchers.contains((String)"something went wrong"));
        ((IndexPopulator)Mockito.verify((Object)populator)).close(false);
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(IndexPopulator indexPopulator, int id, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        return this.addPopulator(this.multipleIndexPopulator, indexPopulator, id, flippableIndexProxy, failedIndexProxyFactory);
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(MultipleIndexPopulator multipleIndexPopulator, IndexPopulator indexPopulator, int id, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        IndexDescriptor descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)id, (int[])new int[]{id})).withName("index_" + id).materialise((long)id);
        return this.addPopulator(multipleIndexPopulator, descriptor, indexPopulator, flippableIndexProxy, failedIndexProxyFactory);
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(MultipleIndexPopulator multipleIndexPopulator, IndexDescriptor descriptor, IndexPopulator indexPopulator, FlippableIndexProxy flippableIndexProxy, FailedIndexProxyFactory failedIndexProxyFactory) {
        return multipleIndexPopulator.addPopulator(indexPopulator, descriptor, flippableIndexProxy, failedIndexProxyFactory, "userIndexDescription");
    }

    private MultipleIndexPopulator.IndexPopulation addPopulator(IndexPopulator indexPopulator, int id) throws FlipFailedKernelException {
        FlippableIndexProxy indexProxy = (FlippableIndexProxy)Mockito.mock(FlippableIndexProxy.class);
        Mockito.when((Object)indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        ((FlippableIndexProxy)Mockito.doAnswer(invocation -> {
            Callable argument = (Callable)invocation.getArgument(0);
            return argument.call();
        }).when((Object)indexProxy)).flip((Callable)ArgumentMatchers.any(Callable.class), (FailedIndexProxyFactory)ArgumentMatchers.any(FailedIndexProxyFactory.class));
        return this.addPopulator(indexPopulator, id, indexProxy, (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class));
    }
}

