/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.eclipse.collections.api.iterator.LongIterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;
import org.neo4j.storageengine.api.RelationshipDirection;

class RelationshipChangesForNodeTest {
    RelationshipChangesForNodeTest() {
    }

    @Test
    void shouldGetRelationships() {
        RelationshipChangesForNode changes = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD);
        int TYPE = 2;
        changes.addRelationship(1L, 2, RelationshipDirection.INCOMING);
        changes.addRelationship(2L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(3L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(4L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(5L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(6L, 2, RelationshipDirection.LOOP);
        LongIterator rawRelationships = changes.getRelationships();
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.asArray((LongIterator)rawRelationships), RelationshipChangesForNodeTest.ids(1L, 2L, 3L, 4L, 5L, 6L));
    }

    @Test
    void shouldGetRelationshipsByTypeAndDirection() {
        RelationshipChangesForNode changes = new RelationshipChangesForNode(RelationshipChangesForNode.DiffStrategy.ADD);
        int TYPE = 2;
        int DECOY_TYPE = 666;
        changes.addRelationship(1L, 2, RelationshipDirection.INCOMING);
        changes.addRelationship(2L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(3L, 2, RelationshipDirection.OUTGOING);
        changes.addRelationship(4L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(5L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(6L, 2, RelationshipDirection.LOOP);
        changes.addRelationship(10L, 666, RelationshipDirection.INCOMING);
        changes.addRelationship(11L, 666, RelationshipDirection.OUTGOING);
        changes.addRelationship(12L, 666, RelationshipDirection.LOOP);
        LongIterator rawIncoming = changes.getRelationships(RelationshipDirection.INCOMING, 2);
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.asArray((LongIterator)rawIncoming), RelationshipChangesForNodeTest.ids(1L));
        LongIterator rawOutgoing = changes.getRelationships(RelationshipDirection.OUTGOING, 2);
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.asArray((LongIterator)rawOutgoing), RelationshipChangesForNodeTest.ids(2L, 3L));
        LongIterator rawLoops = changes.getRelationships(RelationshipDirection.LOOP, 2);
        MatcherAssert.assertThat((Object)PrimitiveLongCollections.asArray((LongIterator)rawLoops), RelationshipChangesForNodeTest.ids(4L, 5L, 6L));
    }

    private static Matcher<long[]> ids(long ... ids) {
        return Matchers.equalTo((Object)ids);
    }
}

