/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.UnmodifiableMap;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.Predicates;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.state.NodeStateImpl;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSets;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSetsImpl;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.DiffSets;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
abstract class TxStateTest {
    @Inject
    private RandomRule random;
    private final IndexDescriptor indexOn_1_1 = TestIndexDescriptorFactory.forLabel(1, 1);
    private final IndexDescriptor indexOn_2_1 = TestIndexDescriptorFactory.forLabel(2, 1);
    private final IndexDescriptor indexOnRels = TestIndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptor.forRelType((int)3, (int[])new int[]{1}));
    private final CollectionsFactorySupplier collectionsFactorySupplier;
    private CollectionsFactory collectionsFactory;
    private TxState state;

    TxStateTest(CollectionsFactorySupplier collectionsFactorySupplier) {
        this.collectionsFactorySupplier = collectionsFactorySupplier;
    }

    @BeforeEach
    void before() {
        this.collectionsFactory = (CollectionsFactory)Mockito.spy((Object)this.collectionsFactorySupplier.create());
        this.state = new TxState(this.collectionsFactory);
    }

    @AfterEach
    void after() {
        this.collectionsFactory.release();
        Assertions.assertEquals((long)0L, (long)this.collectionsFactory.getMemoryTracker().usedDirectMemory(), (String)"Seems like native memory is leaking");
    }

    @Test
    void shouldGetAddedLabels() {
        this.state.nodeDoAddLabel(1L, 0L);
        this.state.nodeDoAddLabel(1L, 1L);
        this.state.nodeDoAddLabel(2L, 1L);
        LongSet addedLabels = this.state.nodeStateLabelDiffSets(1L).getAdded();
        Assertions.assertEquals((Object)LongHashSet.newSetWith((long[])new long[]{1L, 2L}), (Object)addedLabels);
    }

    @Test
    void shouldGetRemovedLabels() {
        this.state.nodeDoRemoveLabel(1L, 0L);
        this.state.nodeDoRemoveLabel(1L, 1L);
        this.state.nodeDoRemoveLabel(2L, 1L);
        LongSet removedLabels = this.state.nodeStateLabelDiffSets(1L).getRemoved();
        Assertions.assertEquals((Object)LongHashSet.newSetWith((long[])new long[]{1L, 2L}), (Object)removedLabels);
    }

    @Test
    void removeAddedLabelShouldRemoveFromAdded() {
        this.state.nodeDoAddLabel(1L, 0L);
        this.state.nodeDoAddLabel(1L, 1L);
        this.state.nodeDoAddLabel(2L, 1L);
        this.state.nodeDoRemoveLabel(1L, 1L);
        Assertions.assertEquals((Object)LongHashSet.newSetWith((long[])new long[]{2L}), (Object)this.state.nodeStateLabelDiffSets(1L).getAdded());
    }

    @Test
    void addRemovedLabelShouldRemoveFromRemoved() {
        this.state.nodeDoRemoveLabel(1L, 0L);
        this.state.nodeDoRemoveLabel(1L, 1L);
        this.state.nodeDoRemoveLabel(2L, 1L);
        this.state.nodeDoAddLabel(1L, 1L);
        Assertions.assertEquals((Object)LongHashSet.newSetWith((long[])new long[]{2L}), (Object)this.state.nodeStateLabelDiffSets(1L).getRemoved());
    }

    @Test
    void shouldMapFromRemovedLabelToNodes() {
        this.state.nodeDoRemoveLabel(1L, 0L);
        this.state.nodeDoRemoveLabel(2L, 0L);
        this.state.nodeDoRemoveLabel(1L, 1L);
        this.state.nodeDoRemoveLabel(3L, 1L);
        this.state.nodeDoRemoveLabel(2L, 2L);
        LongSet nodes = this.state.nodesWithLabelChanged(2L).getRemoved();
        Assertions.assertEquals((Object)LongHashSet.newSetWith((long[])new long[]{0L, 2L}), (Object)nodes);
    }

    @Test
    void shouldComputeIndexUpdatesOnUninitializedTxState() {
        UnmodifiableMap diffSets = this.state.getIndexUpdates(this.indexOn_1_1.schema());
        Assertions.assertNull((Object)diffSets);
    }

    @Test
    void shouldComputeSortedIndexUpdatesOnUninitializedTxState() {
        NavigableMap diffSets = this.state.getSortedIndexUpdates(this.indexOn_1_1.schema());
        Assertions.assertNull((Object)diffSets);
    }

    @Test
    void shouldComputeIndexUpdatesOnEmptyTxState() {
        this.addNodesToIndex(this.indexOn_2_1).withDefaultStringProperties(42L);
        UnmodifiableMap diffSets = this.state.getIndexUpdates(this.indexOn_1_1.schema());
        Assertions.assertNull((Object)diffSets);
    }

    @Test
    void shouldComputeSortedIndexUpdatesOnEmptyTxState() {
        this.addNodesToIndex(this.indexOn_2_1).withDefaultStringProperties(42L);
        NavigableMap diffSets = this.state.getSortedIndexUpdates(this.indexOn_1_1.schema());
        Assertions.assertNull((Object)diffSets);
    }

    @Test
    void shouldComputeIndexUpdatesOnTxStateWithAddedNodes() {
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(42L);
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(43L);
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(41L);
        UnmodifiableMap diffSets = this.state.getIndexUpdates(this.indexOn_1_1.schema());
        Assertions.assertNotNull((Object)diffSets);
        TxStateTest.assertEqualDiffSets(this.addedNodes(42L), (LongDiffSets)diffSets.get((Object)ValueTuple.of((Value[])new Value[]{Values.stringValue((String)"value42")})));
        TxStateTest.assertEqualDiffSets(this.addedNodes(43L), (LongDiffSets)diffSets.get((Object)ValueTuple.of((Value[])new Value[]{Values.stringValue((String)"value43")})));
        TxStateTest.assertEqualDiffSets(this.addedNodes(41L), (LongDiffSets)diffSets.get((Object)ValueTuple.of((Value[])new Value[]{Values.stringValue((String)"value41")})));
    }

    @Test
    void shouldComputeSortedIndexUpdatesOnTxStateWithAddedNodes() {
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(42L);
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(43L);
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(41L);
        NavigableMap diffSets = this.state.getSortedIndexUpdates(this.indexOn_1_1.schema());
        TreeMap<ValueTuple, LongDiffSets> expected = this.sortedAddedNodesDiffSets(42L, 41L, 43L);
        Assertions.assertNotNull((Object)diffSets);
        Assertions.assertEquals(expected.keySet(), diffSets.keySet());
        for (ValueTuple key : expected.keySet()) {
            TxStateTest.assertEqualDiffSets(expected.get(key), (LongDiffSets)diffSets.get(key));
        }
    }

    @Test
    void shouldAddAndGetByLabel() {
        this.state.indexDoAdd(this.indexOn_1_1);
        this.state.indexDoAdd(this.indexOn_2_1);
        SchemaDescriptor schema = this.indexOn_1_1.schema();
        int[] labels = schema.getEntityTokenIds();
        Assertions.assertEquals((Object)schema.entityType(), (Object)EntityType.NODE);
        Assertions.assertEquals((int)labels.length, (int)1);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{this.indexOn_1_1}), (Object)this.state.indexDiffSetsByLabel(labels[0]).getAdded());
    }

    @Test
    void shouldAddAndGetByRelType() {
        this.state.indexDoAdd(this.indexOnRels);
        this.state.indexDoAdd(this.indexOn_2_1);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{this.indexOnRels}), (Object)this.state.indexDiffSetsByRelationshipType(this.indexOnRels.schema().getRelTypeId()).getAdded());
    }

    @Test
    void shouldAddAndGetByRuleId() {
        this.state.indexDoAdd(this.indexOn_1_1);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new IndexDescriptor[]{this.indexOn_1_1}), (Object)this.state.indexChanges().getAdded());
    }

    @Test
    void shouldListNodeAsDeletedIfItIsDeleted() {
        long nodeId = 1337L;
        this.state.nodeDoDelete(nodeId);
        MatcherAssert.assertThat((Object)this.state.addedAndRemovedNodes().getRemoved(), (Matcher)IsEqual.equalTo((Object)LongHashSet.newSetWith((long[])new long[]{nodeId})));
    }

    @Test
    void shouldAddUniquenessConstraint() {
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)1, (int[])new int[]{17});
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema);
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint, IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("constraint_7").materialise(7L));
        DiffSets diff = this.state.constraintsChangesForLabel(1);
        Assertions.assertEquals(Collections.singleton(constraint), (Object)diff.getAdded());
        Assertions.assertTrue((boolean)diff.getRemoved().isEmpty());
    }

    @Test
    void addingUniquenessConstraintShouldBeIdempotent() {
        LabelSchemaDescriptor schema = SchemaDescriptor.forLabel((int)1, (int[])new int[]{17});
        UniquenessConstraintDescriptor constraint1 = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema);
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint1, IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("constraint_7").materialise(7L));
        UniquenessConstraintDescriptor constraint2 = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema);
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint2, IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("constraint_19").materialise(19L));
        Assertions.assertEquals((Object)constraint1, (Object)constraint2);
        Assertions.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForLabel(1).getAdded());
    }

    @Test
    void shouldDifferentiateBetweenUniquenessConstraintsForDifferentLabels() {
        LabelSchemaDescriptor schema1 = SchemaDescriptor.forLabel((int)1, (int[])new int[]{17});
        UniquenessConstraintDescriptor constraint1 = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema1);
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint1, IndexPrototype.uniqueForSchema((SchemaDescriptor)schema1).withName("constraint_7").materialise(7L));
        LabelSchemaDescriptor schema2 = SchemaDescriptor.forLabel((int)2, (int[])new int[]{17});
        UniquenessConstraintDescriptor constraint2 = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema2);
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint2, IndexPrototype.uniqueForSchema((SchemaDescriptor)schema2).withName("constraint_19").materialise(19L));
        Assertions.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForLabel(1).getAdded());
        Assertions.assertEquals(Collections.singleton(constraint2), (Object)this.state.constraintsChangesForLabel(2).getAdded());
    }

    @Test
    void shouldAddRelationshipPropertyExistenceConstraint() {
        RelExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{42});
        this.state.constraintDoAdd((ConstraintDescriptor)constraint);
        Assertions.assertEquals(Collections.singleton(constraint), (Object)this.state.constraintsChangesForRelationshipType(1).getAdded());
    }

    @Test
    void addingRelationshipPropertyExistenceConstraintConstraintShouldBeIdempotent() {
        RelExistenceConstraintDescriptor constraint1 = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{42});
        RelExistenceConstraintDescriptor constraint2 = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{42});
        this.state.constraintDoAdd((ConstraintDescriptor)constraint1);
        this.state.constraintDoAdd((ConstraintDescriptor)constraint2);
        Assertions.assertEquals((Object)constraint1, (Object)constraint2);
        Assertions.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForRelationshipType(1).getAdded());
    }

    @Test
    void shouldDropRelationshipPropertyExistenceConstraint() {
        RelExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{42});
        this.state.constraintDoAdd((ConstraintDescriptor)constraint);
        this.state.constraintDoDrop((ConstraintDescriptor)constraint);
        Assertions.assertTrue((boolean)this.state.constraintsChangesForRelationshipType(1).isEmpty());
    }

    @Test
    void shouldDifferentiateRelationshipPropertyExistenceConstraints() {
        RelExistenceConstraintDescriptor constraint1 = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{11});
        RelExistenceConstraintDescriptor constraint2 = ConstraintDescriptorFactory.existsForRelType((int)1, (int[])new int[]{22});
        RelExistenceConstraintDescriptor constraint3 = ConstraintDescriptorFactory.existsForRelType((int)3, (int[])new int[]{33});
        this.state.constraintDoAdd((ConstraintDescriptor)constraint1);
        this.state.constraintDoAdd((ConstraintDescriptor)constraint2);
        this.state.constraintDoAdd((ConstraintDescriptor)constraint3);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint1, constraint2}), (Object)this.state.constraintsChangesForRelationshipType(1).getAdded());
        Assertions.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForSchema(constraint1.schema()).getAdded());
        Assertions.assertEquals(Collections.singleton(constraint2), (Object)this.state.constraintsChangesForSchema(constraint2.schema()).getAdded());
        Assertions.assertEquals(Collections.singleton(constraint3), (Object)this.state.constraintsChangesForRelationshipType(3).getAdded());
        Assertions.assertEquals(Collections.singleton(constraint3), (Object)this.state.constraintsChangesForSchema(constraint3.schema()).getAdded());
    }

    @Test
    void shouldListRelationshipsAsCreatedIfCreated() {
        long relId = 10L;
        this.state.relationshipDoCreate(relId, 0, 1L, 2L);
        Assertions.assertTrue((boolean)this.state.hasChanges());
        Assertions.assertTrue((boolean)this.state.relationshipIsAddedInThisTx(relId));
    }

    @Test
    void shouldNotChangeRecordForCreatedAndDeletedNode() throws Exception {
        this.state.nodeDoCreate(0L);
        this.state.nodeDoDelete(0L);
        this.state.nodeDoCreate(1L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitCreatedNode(long id) {
                Assertions.assertEquals((long)1L, (long)id, (String)"Should not create any other node than 1");
            }

            public void visitDeletedNode(long id) {
                Assertions.fail((String)"Should not delete any node");
            }
        });
    }

    @Test
    void shouldVisitDeletedNode() throws Exception {
        this.state.nodeDoDelete(42L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitDeletedNode(long id) {
                Assertions.assertEquals((long)42L, (long)id, (String)"Wrong deleted node id");
            }
        });
    }

    @Test
    void shouldReportDeletedNodeIfItWasCreatedAndDeletedInSameTx() {
        long nodeId = 42L;
        this.state.nodeDoCreate(nodeId);
        this.state.nodeDoDelete(nodeId);
        Assertions.assertTrue((boolean)this.state.nodeIsDeletedInThisTx(nodeId));
    }

    @Test
    void shouldNotReportDeletedNodeIfItIsNotDeleted() {
        long nodeId = 42L;
        this.state.nodeDoCreate(nodeId);
        Assertions.assertFalse((boolean)this.state.nodeIsDeletedInThisTx(nodeId));
    }

    @Test
    void shouldNotChangeRecordForCreatedAndDeletedRelationship() throws Exception {
        this.state.relationshipDoCreate(0L, 0, 1L, 2L);
        this.state.relationshipDoDelete(0L, 0, 1L, 2L);
        this.state.relationshipDoCreate(1L, 0, 2L, 3L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                Assertions.assertEquals((long)1L, (long)id, (String)"Should not create any other relationship than 1");
            }

            public void visitDeletedRelationship(long id) {
                Assertions.fail((String)"Should not delete any relationship");
            }
        });
    }

    @Test
    void doNotVisitNotModifiedPropertiesOnModifiedNodes() throws KernelException {
        this.state.nodeDoAddLabel(5L, 1L);
        final MutableBoolean labelsChecked = new MutableBoolean();
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) {
                labelsChecked.setTrue();
                Assertions.assertEquals((long)1L, (long)id);
                Assertions.assertEquals((int)1, (int)added.size());
                Assertions.assertTrue((boolean)added.contains(5L));
                Assertions.assertTrue((boolean)removed.isEmpty());
            }

            public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
                Assertions.fail((String)"Properties were not changed.");
            }
        });
        Assertions.assertTrue((boolean)labelsChecked.booleanValue());
    }

    @Test
    void doNotVisitNotModifiedLabelsOnModifiedNodes() throws KernelException {
        this.state.nodeDoAddProperty(1L, 2, (Value)Values.stringValue((String)"propertyValue"));
        final MutableBoolean propertiesChecked = new MutableBoolean();
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) {
                Assertions.fail((String)"Labels were not changed.");
            }

            public void visitNodePropertyChanges(long id, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, IntIterable removed) {
                propertiesChecked.setTrue();
                Assertions.assertEquals((long)1L, (long)id);
                Assertions.assertFalse((boolean)changed.hasNext());
                Assertions.assertTrue((boolean)removed.isEmpty());
                Assertions.assertEquals((long)1L, (long)Iterators.count(added, (Predicate)Predicates.alwaysTrue()));
            }
        });
        Assertions.assertTrue((boolean)propertiesChecked.booleanValue());
    }

    @Test
    void shouldVisitDeletedRelationship() throws Exception {
        this.state.relationshipDoDelete(42L, 2, 3L, 4L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitDeletedRelationship(long id) {
                Assertions.assertEquals((long)42L, (long)id, (String)"Wrong deleted relationship id");
            }
        });
    }

    @Test
    void shouldReportDeletedRelationshipIfItWasCreatedAndDeletedInSameTx() {
        long startNodeId = 1L;
        long relationshipId = 2L;
        int relationshipType = 3;
        long endNodeId = 4L;
        this.state.relationshipDoCreate(relationshipId, relationshipType, startNodeId, endNodeId);
        this.state.relationshipDoDelete(relationshipId, relationshipType, startNodeId, endNodeId);
        Assertions.assertTrue((boolean)this.state.relationshipIsDeletedInThisTx(relationshipId));
    }

    @Test
    void shouldNotReportDeletedRelationshipIfItIsNotDeleted() {
        long startNodeId = 1L;
        long relationshipId = 2L;
        int relationshipType = 3;
        long endNodeId = 4L;
        this.state.relationshipDoCreate(relationshipId, relationshipType, startNodeId, endNodeId);
        Assertions.assertFalse((boolean)this.state.relationshipIsDeletedInThisTx(relationshipId));
    }

    @RepeatedTest(value=100)
    void shouldVisitCreatedNodesBeforeDeletedNodes() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.nodeDoCreate((long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.nodeDoDelete((long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedNode(long id) {
                this.visitEarly();
            }

            public void visitDeletedNode(long id) {
                this.visitLate();
            }
        });
    }

    @RepeatedTest(value=100)
    void shouldVisitCreatedNodesBeforeCreatedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.nodeDoCreate((long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedNode(long id) {
                this.visitEarly();
            }

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                this.visitLate();
            }
        });
    }

    @RepeatedTest(value=100)
    void shouldVisitCreatedRelationshipsBeforeDeletedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.relationshipDoDelete((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                this.visitEarly();
            }

            public void visitDeletedRelationship(long id) {
                this.visitLate();
            }
        });
    }

    @RepeatedTest(value=100)
    void shouldVisitDeletedNodesAfterDeletedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.nodeDoDelete((long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitDeletedRelationship(long id) {
                this.visitEarly();
            }

            public void visitDeletedNode(long id) {
                this.visitLate();
            }
        });
    }

    @Test
    void dataRevisionMustChangeOnDataChange() {
        MatcherAssert.assertThat((Object)this.state.getDataRevision(), (Matcher)Matchers.is((Object)0L));
        Assertions.assertFalse((boolean)this.state.hasDataChanges());
        LongHashSet observedRevisions = new LongHashSet();
        observedRevisions.add(0L);
        this.state.nodeDoCreate(0L);
        Assertions.assertTrue((boolean)observedRevisions.add(this.state.getDataRevision()));
        Assertions.assertTrue((boolean)this.state.hasDataChanges());
        this.state.nodeDoAddLabel(0L, 0L);
        Assertions.assertTrue((boolean)observedRevisions.add(this.state.getDataRevision()));
        Assertions.assertTrue((boolean)this.state.hasDataChanges());
        this.state.nodeDoRemoveLabel(0L, 0L);
        Assertions.assertTrue((boolean)observedRevisions.add(this.state.getDataRevision()));
        Assertions.assertTrue((boolean)this.state.hasDataChanges());
        this.state.nodeDoAddProperty(0L, 0, (Value)Values.booleanValue((boolean)true));
        Assertions.assertTrue((boolean)observedRevisions.add(this.state.getDataRevision()));
        Assertions.assertTrue((boolean)this.state.hasDataChanges());
        this.state.nodeDoChangeProperty(0L, 0, (Value)Values.booleanValue((boolean)false));
        Assertions.assertTrue((boolean)observedRevisions.add(this.state.getDataRevision()));
        Assertions.assertTrue((boolean)this.state.hasDataChanges());
        this.state.nodeDoRemoveProperty(0L, 0);
        Assertions.assertTrue((boolean)observedRevisions.add(this.state.getDataRevision()));
        Assertions.assertTrue((boolean)this.state.hasDataChanges());
        this.state.nodeDoDelete(0L);
        Assertions.assertTrue((boolean)observedRevisions.add(this.state.getDataRevision()));
        Assertions.assertTrue((boolean)this.state.hasDataChanges());
        this.state.relationshipDoCreate(0L, 0, 0L, 0L);
        Assertions.assertTrue((boolean)observedRevisions.add(this.state.getDataRevision()));
        Assertions.assertTrue((boolean)this.state.hasDataChanges());
        this.state.relationshipDoReplaceProperty(0L, 0, Values.NO_VALUE, (Value)Values.booleanValue((boolean)true));
        Assertions.assertTrue((boolean)observedRevisions.add(this.state.getDataRevision()));
        Assertions.assertTrue((boolean)this.state.hasDataChanges());
        this.state.relationshipDoReplaceProperty(0L, 0, (Value)Values.booleanValue((boolean)true), (Value)Values.booleanValue((boolean)false));
        Assertions.assertTrue((boolean)observedRevisions.add(this.state.getDataRevision()));
        Assertions.assertTrue((boolean)this.state.hasDataChanges());
        this.state.relationshipDoRemoveProperty(0L, 0);
        Assertions.assertTrue((boolean)observedRevisions.add(this.state.getDataRevision()));
        Assertions.assertTrue((boolean)this.state.hasDataChanges());
        this.state.relationshipDoDeleteAddedInThisTx(0L);
        Assertions.assertTrue((boolean)observedRevisions.add(this.state.getDataRevision()));
        Assertions.assertTrue((boolean)this.state.hasDataChanges());
        this.state.relationshipDoDelete(1L, 0, 0L, 0L);
        Assertions.assertTrue((boolean)observedRevisions.add(this.state.getDataRevision()));
        Assertions.assertTrue((boolean)this.state.hasDataChanges());
    }

    @Test
    void dataRevisionMustNotChangeOnSchemaChanges() {
        MatcherAssert.assertThat((Object)this.state.getDataRevision(), (Matcher)Matchers.is((Object)0L));
        Assertions.assertFalse((boolean)this.state.hasDataChanges());
        this.state.indexDoAdd(this.indexOn_1_1);
        MatcherAssert.assertThat((Object)this.state.getDataRevision(), (Matcher)Matchers.is((Object)0L));
        Assertions.assertFalse((boolean)this.state.hasDataChanges());
        this.state.indexDoDrop(this.indexOn_1_1);
        MatcherAssert.assertThat((Object)this.state.getDataRevision(), (Matcher)Matchers.is((Object)0L));
        Assertions.assertFalse((boolean)this.state.hasDataChanges());
        this.state.indexDoUnRemove(this.indexOn_1_1);
        MatcherAssert.assertThat((Object)this.state.getDataRevision(), (Matcher)Matchers.is((Object)0L));
        Assertions.assertFalse((boolean)this.state.hasDataChanges());
        UniquenessConstraintDescriptor constraint1 = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{17});
        this.state.constraintDoAdd((ConstraintDescriptor)constraint1);
        MatcherAssert.assertThat((Object)this.state.getDataRevision(), (Matcher)Matchers.is((Object)0L));
        Assertions.assertFalse((boolean)this.state.hasDataChanges());
        this.state.constraintDoDrop((ConstraintDescriptor)constraint1);
        MatcherAssert.assertThat((Object)this.state.getDataRevision(), (Matcher)Matchers.is((Object)0L));
        Assertions.assertFalse((boolean)this.state.hasDataChanges());
        this.state.constraintDoUnRemove((ConstraintDescriptor)constraint1);
        MatcherAssert.assertThat((Object)this.state.getDataRevision(), (Matcher)Matchers.is((Object)0L));
        Assertions.assertFalse((boolean)this.state.hasDataChanges());
        NodeKeyConstraintDescriptor constraint2 = ConstraintDescriptorFactory.nodeKeyForLabel((int)0, (int[])new int[]{0});
        this.state.constraintDoAdd((IndexBackedConstraintDescriptor)constraint2, IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)0, (int[])new int[]{0})).withName("index").materialise(0L));
        MatcherAssert.assertThat((Object)this.state.getDataRevision(), (Matcher)Matchers.is((Object)0L));
        Assertions.assertFalse((boolean)this.state.hasDataChanges());
        this.state.labelDoCreateForName("Label", false, 0L);
        MatcherAssert.assertThat((Object)this.state.getDataRevision(), (Matcher)Matchers.is((Object)0L));
        Assertions.assertFalse((boolean)this.state.hasDataChanges());
        this.state.relationshipTypeDoCreateForName("REL", false, 0);
        MatcherAssert.assertThat((Object)this.state.getDataRevision(), (Matcher)Matchers.is((Object)0L));
        Assertions.assertFalse((boolean)this.state.hasDataChanges());
        this.state.propertyKeyDoCreateForName("prop", false, 0);
        MatcherAssert.assertThat((Object)this.state.getDataRevision(), (Matcher)Matchers.is((Object)0L));
        Assertions.assertFalse((boolean)this.state.hasDataChanges());
        this.state.indexDoUpdateEntry(this.indexOn_1_1.schema(), 0L, ValueTuple.of((Value[])new Value[]{Values.booleanValue((boolean)true)}), ValueTuple.of((Value[])new Value[]{Values.booleanValue((boolean)false)}));
        MatcherAssert.assertThat((Object)this.state.getDataRevision(), (Matcher)Matchers.is((Object)0L));
        Assertions.assertFalse((boolean)this.state.hasDataChanges());
    }

    @Test
    void getOrCreateNodeState_props_useCollectionsFactory() {
        NodeStateImpl nodeState = this.state.getOrCreateNodeState(1L);
        nodeState.addProperty(2, (Value)Values.stringValue((String)"foo"));
        nodeState.removeProperty(3);
        nodeState.changeProperty(4, (Value)Values.stringValue((String)"bar"));
        ((CollectionsFactory)Mockito.verify((Object)this.collectionsFactory, (VerificationMode)VerificationModeFactory.times((int)2))).newValuesMap();
        ((CollectionsFactory)Mockito.verify((Object)this.collectionsFactory)).newLongSet();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.collectionsFactory});
    }

    @Test
    void getOrCreateLabelStateNodeDiffSets_useCollectionsFactory() {
        MutableLongDiffSets diffSets = this.state.getOrCreateLabelStateNodeDiffSets(1L);
        diffSets.add(1L);
        diffSets.remove(2L);
        ((CollectionsFactory)Mockito.verify((Object)this.collectionsFactory, (VerificationMode)VerificationModeFactory.times((int)2))).newLongSet();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.collectionsFactory});
    }

    @Test
    void getOrCreateIndexUpdatesForSeek_useCollectionsFactory() {
        MutableLongDiffSets diffSets = this.state.getOrCreateIndexUpdatesForSeek(new HashMap(), ValueTuple.of((Value[])new Value[]{Values.stringValue((String)"test")}));
        diffSets.add(1L);
        diffSets.remove(2L);
        ((CollectionsFactory)Mockito.verify((Object)this.collectionsFactory, (VerificationMode)VerificationModeFactory.times((int)2))).newLongSet();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.collectionsFactory});
    }

    private LongDiffSets addedNodes(long ... added) {
        return new MutableLongDiffSetsImpl(LongSets.mutable.of(added), LongSets.mutable.empty(), this.collectionsFactory);
    }

    private TreeMap<ValueTuple, LongDiffSets> sortedAddedNodesDiffSets(long ... added) {
        TreeMap<ValueTuple, LongDiffSets> map = new TreeMap<ValueTuple, LongDiffSets>(ValueTuple.COMPARATOR);
        for (long node : added) {
            map.put(ValueTuple.of((Value[])new Value[]{Values.stringValue((String)("value" + node))}), this.addedNodes(node));
        }
        return map;
    }

    private IndexUpdater addNodesToIndex(final IndexDescriptor descriptor) {
        return new IndexUpdater(){

            @Override
            public void withDefaultStringProperties(long ... nodeIds) {
                ArrayList entries = new ArrayList(nodeIds.length);
                for (long nodeId : nodeIds) {
                    entries.add(Pair.of((Object)nodeId, (Object)("value" + nodeId)));
                }
                this.withProperties(entries);
            }

            private <T> void withProperties(Collection<Pair<Long, T>> nodesWithValues) {
                SchemaDescriptor schema = descriptor.schema();
                int[] labelIds = schema.getEntityTokenIds();
                int[] propertyKeyIds = schema.getPropertyIds();
                Assertions.assertEquals((int)labelIds.length, (int)1);
                Assertions.assertEquals((int)propertyKeyIds.length, (int)1);
                for (Pair<Long, T> entry : nodesWithValues) {
                    long nodeId = (Long)entry.first();
                    TxStateTest.this.state.nodeDoCreate(nodeId);
                    TxStateTest.this.state.nodeDoAddLabel((long)labelIds[0], nodeId);
                    Value valueAfter = Values.of((Object)entry.other());
                    TxStateTest.this.state.nodeDoAddProperty(nodeId, propertyKeyIds[0], valueAfter);
                    TxStateTest.this.state.indexDoUpdateEntry(schema, nodeId, null, ValueTuple.of((Value[])new Value[]{valueAfter}));
                }
            }
        };
    }

    private static void assertEqualDiffSets(LongDiffSets expected, LongDiffSets actual) {
        Assertions.assertEquals((Object)expected.getRemoved(), (Object)actual.getRemoved());
        Assertions.assertEquals((Object)expected.getAdded(), (Object)actual.getAdded());
    }

    private static interface IndexUpdater {
        public void withDefaultStringProperties(long ... var1);
    }

    abstract class VisitationOrder
    extends TxStateVisitor.Adapter {
        private final Set<String> visitMethods = new HashSet<String>();
        private boolean late;

        VisitationOrder(int size) {
            for (Method method : ((Object)((Object)this)).getClass().getDeclaredMethods()) {
                if (!method.getName().startsWith("visit")) continue;
                this.visitMethods.add(method.getName());
            }
            Assertions.assertEquals((int)2, (int)this.visitMethods.size(), (String)"should implement exactly two visit*(...) methods");
            do {
                if (TxStateTest.this.random.nextBoolean()) {
                    this.createEarlyState();
                    continue;
                }
                this.createLateState();
            } while (size-- > 0);
        }

        abstract void createEarlyState();

        abstract void createLateState();

        final void visitEarly() {
            if (this.late) {
                String early = "the early visit*-method";
                String late = "the late visit*-method";
                for (StackTraceElement trace : Thread.currentThread().getStackTrace()) {
                    if (!this.visitMethods.contains(trace.getMethodName())) continue;
                    early = trace.getMethodName();
                    for (String method : this.visitMethods) {
                        if (method.equals(early)) continue;
                        late = method;
                    }
                    break;
                }
                Assertions.fail((String)(early + "(...) should not be invoked after " + late + "(...)"));
            }
        }

        final void visitLate() {
            this.late = true;
        }
    }
}

