/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.transaciton.monitor;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.api.transaction.monitor.KernelTransactionMonitor;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

class KernelTransactionMonitorTest {
    KernelTransactionMonitorTest() {
    }

    @Test
    void shouldNotTimeoutSchemaTransactions() {
        KernelTransactions kernelTransactions = (KernelTransactions)Mockito.mock(KernelTransactions.class);
        FakeClock clock = new FakeClock(100L, TimeUnit.MINUTES);
        KernelTransactionMonitor monitor = new KernelTransactionMonitor(kernelTransactions, (SystemNanoClock)clock, (LogService)NullLogService.getInstance());
        KernelTransactionHandle oldSchemaTransaction = (KernelTransactionHandle)Mockito.mock(KernelTransactionHandle.class);
        Mockito.when((Object)oldSchemaTransaction.isSchemaTransaction()).thenReturn((Object)true);
        Mockito.when((Object)oldSchemaTransaction.startTime()).thenReturn((Object)(clock.millis() - TimeUnit.MINUTES.toMillis(2L)));
        Mockito.when((Object)oldSchemaTransaction.timeoutMillis()).thenReturn((Object)TimeUnit.MINUTES.toMillis(1L));
        Mockito.when((Object)kernelTransactions.activeTransactions()).thenReturn((Object)Iterators.asSet((Object[])new KernelTransactionHandle[]{oldSchemaTransaction}));
        monitor.run();
        ((KernelTransactionHandle)Mockito.verify((Object)oldSchemaTransaction, (VerificationMode)Mockito.times((int)1))).isSchemaTransaction();
        ((KernelTransactionHandle)Mockito.verify((Object)oldSchemaTransaction, (VerificationMode)Mockito.never())).markForTermination((Status)ArgumentMatchers.any());
    }
}

