/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;

public class FullScanNonUniqueIndexSamplerTest
extends NativeIndexTestUtil<GenericKey, NativeIndexValue> {
    private static final IndexSpecificSpaceFillingCurveSettings specificSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());

    @Test
    void shouldIncludeAllValuesInTree() throws Exception {
        IndexSample sample;
        Value[] values = this.generateNumberValues();
        this.buildTree(values);
        try (GBPTree gbpTree = this.getTree();){
            FullScanNonUniqueIndexSampler sampler = new FullScanNonUniqueIndexSampler(gbpTree, this.layout);
            sample = sampler.result();
        }
        Assertions.assertEquals((long)values.length, (long)sample.sampleSize());
        Assertions.assertEquals((long)ValueCreatorUtil.countUniqueValues(values), (long)sample.uniqueValues());
        Assertions.assertEquals((long)values.length, (long)sample.indexSize());
    }

    private Value[] generateNumberValues() {
        ValueType[] numberTypes = RandomValues.including(t -> t.valueGroup == ValueGroup.NUMBER);
        int size = 20;
        NumberValue[] result = new NumberValue[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.random.randomValues().nextValueOfTypes(numberTypes);
        }
        return result;
    }

    private void buildTree(Value[] values) throws IOException {
        try (GBPTree gbpTree = this.getTree();){
            try (Writer writer = gbpTree.writer();){
                GenericKey key = (GenericKey)this.layout.newKey();
                NativeIndexValue value = this.layout.newValue();
                long nodeId = 0L;
                for (Value number : values) {
                    key.initialize(nodeId);
                    key.initFromValue(0, number, NativeIndexKey.Inclusion.NEUTRAL);
                    value.from(new Value[]{number});
                    writer.put((Object)key, (Object)value);
                    ++nodeId;
                }
            }
            gbpTree.checkpoint(IOLimiter.UNLIMITED);
        }
    }

    @Override
    protected ValueCreatorUtil<GenericKey, NativeIndexValue> createValueCreatorUtil() {
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)42, (int[])new int[]{666})).withName("index").materialise(0L);
        return new ValueCreatorUtil<GenericKey, NativeIndexValue>(index, RandomValues.typesOfGroup((ValueGroup)ValueGroup.NUMBER), 0.1);
    }

    @Override
    IndexLayout<GenericKey, NativeIndexValue> createLayout() {
        return new GenericLayout(1, specificSettings);
    }
}

