/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

class ValueCreatorUtil<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> {
    static final double FRACTION_DUPLICATE_UNIQUE = 0.0;
    static final double FRACTION_DUPLICATE_NON_UNIQUE = 0.1;
    private static final double FRACTION_EXTREME_VALUE = 0.25;
    private static final Comparator<IndexEntryUpdate<IndexDescriptor>> UPDATE_COMPARATOR = (u1, u2) -> Values.COMPARATOR.compare(u1.values()[0], u2.values()[0]);
    private static final int N_VALUES = 10;
    final IndexDescriptor indexDescriptor;
    private final ValueType[] supportedTypes;
    private final double fractionDuplicates;

    ValueCreatorUtil(ValueCreatorUtil delegate) {
        this(delegate.indexDescriptor, delegate.supportedTypes, delegate.fractionDuplicates);
    }

    ValueCreatorUtil(IndexDescriptor indexDescriptor, ValueType[] supportedTypes, double fractionDuplicates) {
        this.indexDescriptor = indexDescriptor;
        this.supportedTypes = supportedTypes;
        this.fractionDuplicates = fractionDuplicates;
    }

    int compareIndexedPropertyValue(KEY key1, KEY key2) {
        return Values.COMPARATOR.compare(key1.asValues()[0], key2.asValues()[0]);
    }

    ValueType[] supportedTypes() {
        return this.supportedTypes;
    }

    private double fractionDuplicates() {
        return this.fractionDuplicates;
    }

    IndexQuery rangeQuery(Value from, boolean fromInclusive, Value to, boolean toInclusive) {
        return IndexQuery.range((int)0, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive);
    }

    IndexDescriptor indexDescriptor() {
        return this.indexDescriptor;
    }

    IndexEntryUpdate<IndexDescriptor>[] someUpdates(RandomRule randomRule) {
        return this.someUpdates(randomRule, this.supportedTypes(), this.fractionDuplicates());
    }

    IndexEntryUpdate<IndexDescriptor>[] someUpdates(RandomRule random, ValueType[] types, boolean allowDuplicates) {
        double fractionDuplicates = allowDuplicates ? 0.1 : 0.0;
        return this.someUpdates(random, types, fractionDuplicates);
    }

    private IndexEntryUpdate<IndexDescriptor>[] someUpdates(RandomRule random, ValueType[] types, double fractionDuplicates) {
        RandomValueGenerator valueGenerator = new RandomValueGenerator(random.randomValues(), types, fractionDuplicates);
        RandomUpdateGenerator randomUpdateGenerator = new RandomUpdateGenerator((Iterator<Value>)((Object)valueGenerator));
        IndexEntryUpdate[] result = new IndexEntryUpdate[10];
        for (int i = 0; i < 10; ++i) {
            result[i] = (IndexEntryUpdate)randomUpdateGenerator.next();
        }
        return result;
    }

    IndexEntryUpdate<IndexDescriptor>[] someUpdatesWithDuplicateValues(RandomRule randomRule) {
        RandomValueGenerator valueIterator = new RandomValueGenerator(randomRule.randomValues(), this.supportedTypes(), this.fractionDuplicates());
        Object[] someValues = new Value[10];
        for (int i = 0; i < 10; ++i) {
            someValues[i] = (Value)valueIterator.next();
        }
        return this.generateAddUpdatesFor((Value[])ArrayUtils.addAll((Object[])someValues, (Object[])someValues));
    }

    Iterator<IndexEntryUpdate<IndexDescriptor>> randomUpdateGenerator(RandomRule randomRule) {
        return this.randomUpdateGenerator(randomRule, this.supportedTypes());
    }

    Iterator<IndexEntryUpdate<IndexDescriptor>> randomUpdateGenerator(RandomRule random, ValueType[] types) {
        RandomValueGenerator valueIterator = new RandomValueGenerator(random.randomValues(), types, this.fractionDuplicates());
        return new RandomUpdateGenerator((Iterator<Value>)((Object)valueIterator));
    }

    IndexEntryUpdate<IndexDescriptor>[] generateAddUpdatesFor(Value[] values) {
        IndexEntryUpdate[] indexEntryUpdates = new IndexEntryUpdate[values.length];
        for (int i = 0; i < indexEntryUpdates.length; ++i) {
            indexEntryUpdates[i] = this.add(i, values[i]);
        }
        return indexEntryUpdates;
    }

    Value[] extractValuesFromUpdates(IndexEntryUpdate<IndexDescriptor>[] updates) {
        Value[] values = new Value[updates.length];
        for (int i = 0; i < updates.length; ++i) {
            if (updates[i].values().length > 1) {
                throw new UnsupportedOperationException("This method does not support composite entries");
            }
            values[i] = updates[i].values()[0];
        }
        return values;
    }

    protected IndexEntryUpdate<IndexDescriptor> add(long nodeId, Value value) {
        return IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.indexDescriptor, (Value[])new Value[]{value});
    }

    static int countUniqueValues(IndexEntryUpdate<IndexDescriptor>[] updates) {
        return Stream.of(updates).map(update -> update.values()[0]).collect(Collectors.toSet()).size();
    }

    static int countUniqueValues(Value[] updates) {
        TreeSet<Value> set = new TreeSet<Value>((Comparator<Value>)Values.COMPARATOR);
        set.addAll(Arrays.asList(updates));
        return set.size();
    }

    void sort(IndexEntryUpdate<IndexDescriptor>[] updates) {
        Arrays.sort(updates, UPDATE_COMPARATOR);
    }

    void copyValue(VALUE value, VALUE intoValue) {
    }

    private class RandomUpdateGenerator
    extends PrefetchingIterator<IndexEntryUpdate<IndexDescriptor>> {
        private final Iterator<Value> valueIterator;
        private long currentEntityId;

        RandomUpdateGenerator(Iterator<Value> valueIterator) {
            this.valueIterator = valueIterator;
        }

        protected IndexEntryUpdate<IndexDescriptor> fetchNextOrNull() {
            Value value = this.valueIterator.next();
            return ValueCreatorUtil.this.add(this.currentEntityId++, value);
        }
    }

    private class RandomValueGenerator
    extends PrefetchingIterator<Value> {
        private final Set<Value> uniqueCompareValues;
        private final List<Value> uniqueValues;
        private final ValueType[] types;
        private final double fractionDuplicates;
        private final RandomValues randomValues;

        RandomValueGenerator(RandomValues randomValues, ValueType[] types, double fractionDuplicates) {
            this.types = types;
            this.fractionDuplicates = fractionDuplicates;
            this.randomValues = randomValues;
            this.uniqueCompareValues = new HashSet<Value>();
            this.uniqueValues = new ArrayList<Value>();
        }

        protected Value fetchNextOrNull() {
            Value value = this.fractionDuplicates > 0.0 && !this.uniqueValues.isEmpty() && (double)this.randomValues.nextFloat() < this.fractionDuplicates ? (Value)this.randomValues.among(this.uniqueValues) : this.newUniqueValue(this.randomValues, this.uniqueCompareValues, this.uniqueValues);
            return value;
        }

        private Value newUniqueValue(RandomValues random, Set<Value> uniqueCompareValues, List<Value> uniqueValues) {
            Value value;
            int attempts = 0;
            int maxAttempts = 10;
            do {
                ValueType type = (ValueType)this.randomValues.among((Object[])this.types);
                boolean useExtremeValue = ++attempts == 1 && this.randomValues.nextDouble() < 0.25;
                value = useExtremeValue ? (Value)this.randomValues.among((Object[])type.extremeValues()) : random.nextValueOfType(type);
            } while (attempts < maxAttempts && !uniqueCompareValues.add(value));
            uniqueValues.add(value);
            return value;
        }
    }
}

