/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.locking.LockClientStateHolder;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;

class LockClientStateHolderTest {
    LockClientStateHolderTest() {
    }

    @Test
    void shouldAllowIncrementDecrementClientsWhileNotClosed() {
        LockClientStateHolder lockClientStateHolder = new LockClientStateHolder();
        Assertions.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        Assertions.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        lockClientStateHolder.decrementActiveClients();
        lockClientStateHolder.decrementActiveClients();
        lockClientStateHolder.decrementActiveClients();
        Assertions.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
    }

    @Test
    void shouldNotAllowNewClientsWhenClosed() {
        LockClientStateHolder lockClientStateHolder = new LockClientStateHolder();
        lockClientStateHolder.stopClient();
        Assertions.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
        Assertions.assertThrows(LockClientStoppedException.class, () -> lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient()));
    }

    @Test
    void shouldBeAbleToDecrementActiveItemAndDetectWhenFree() {
        LockClientStateHolder lockClientStateHolder = new LockClientStateHolder();
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        lockClientStateHolder.decrementActiveClients();
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        Assertions.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.stopClient();
        Assertions.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.decrementActiveClients();
        Assertions.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.decrementActiveClients();
        Assertions.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
    }

    @Test
    void shouldBeAbleToResetAndReuseClientState() {
        LockClientStateHolder lockClientStateHolder = new LockClientStateHolder();
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        lockClientStateHolder.decrementActiveClients();
        Assertions.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.stopClient();
        Assertions.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        Assertions.assertTrue((boolean)lockClientStateHolder.isStopped());
        lockClientStateHolder.reset();
        Assertions.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
        Assertions.assertFalse((boolean)lockClientStateHolder.isStopped());
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        Assertions.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        Assertions.assertFalse((boolean)lockClientStateHolder.isStopped());
    }
}

