/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.newapi.RelationshipReferenceEncoding;

class ReferencesTest {
    private static final long MAX_ID_LIMIT = 0x4000000000000L;

    ReferencesTest() {
    }

    @Test
    void shouldPreserveNoId() {
        MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.encodeDense((long)-1L), (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.encodeSelection((long)-1L), (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.encodeDenseSelection((long)-1L), (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.encodeNoIncoming((int)-1), (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.encodeNoOutgoing((int)-1), (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.encodeNoLoops((int)-1), (Matcher)CoreMatchers.equalTo((Object)-1L));
    }

    @Test
    void shouldClearFlags() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 1000; ++i) {
            long reference = random.nextLong(0x4000000000000L);
            int token = random.nextInt(Integer.MAX_VALUE);
            MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.clearEncoding((long)RelationshipReferenceEncoding.encodeDense((long)reference)), (Matcher)CoreMatchers.equalTo((Object)reference));
            MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.clearEncoding((long)RelationshipReferenceEncoding.encodeSelection((long)reference)), (Matcher)CoreMatchers.equalTo((Object)reference));
            MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.clearEncoding((long)RelationshipReferenceEncoding.encodeDenseSelection((long)reference)), (Matcher)CoreMatchers.equalTo((Object)reference));
            MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.clearEncoding((long)RelationshipReferenceEncoding.encodeNoIncoming((int)token)), (Matcher)CoreMatchers.equalTo((Object)token));
            MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.clearEncoding((long)RelationshipReferenceEncoding.encodeNoOutgoing((int)token)), (Matcher)CoreMatchers.equalTo((Object)token));
            MatcherAssert.assertThat((Object)RelationshipReferenceEncoding.clearEncoding((long)RelationshipReferenceEncoding.encodeNoLoops((int)token)), (Matcher)CoreMatchers.equalTo((Object)token));
        }
    }

    @Test
    void encodeDense() {
        this.testLongFlag(RelationshipReferenceEncoding.DENSE, RelationshipReferenceEncoding::encodeDense);
    }

    @Test
    void encodeSelection() {
        this.testLongFlag(RelationshipReferenceEncoding.SELECTION, RelationshipReferenceEncoding::encodeSelection);
    }

    @Test
    void encodeDenseSelection() {
        this.testLongFlag(RelationshipReferenceEncoding.DENSE_SELECTION, RelationshipReferenceEncoding::encodeDenseSelection);
    }

    @Test
    void encodeNoIncomingRels() {
        this.testIntFlag(RelationshipReferenceEncoding.NO_INCOMING_OF_TYPE, RelationshipReferenceEncoding::encodeNoIncoming);
    }

    @Test
    void encodeNoOutgoingRels() {
        this.testIntFlag(RelationshipReferenceEncoding.NO_OUTGOING_OF_TYPE, RelationshipReferenceEncoding::encodeNoOutgoing);
    }

    @Test
    void encodeNoLoopRels() {
        this.testIntFlag(RelationshipReferenceEncoding.NO_LOOPS_OF_TYPE, RelationshipReferenceEncoding::encodeNoLoops);
    }

    private void testLongFlag(RelationshipReferenceEncoding flag, LongToLongFunction encoder) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 1000; ++i) {
            long reference = random.nextLong(0x4000000000000L);
            Assertions.assertNotEquals((Object)flag, (Object)RelationshipReferenceEncoding.parseEncoding((long)reference));
            Assertions.assertEquals((Object)flag, (Object)RelationshipReferenceEncoding.parseEncoding((long)encoder.applyAsLong(reference)));
            Assertions.assertTrue((encoder.applyAsLong(reference) < 0L ? 1 : 0) != 0, (String)"encoded reference is negative");
        }
    }

    private void testIntFlag(RelationshipReferenceEncoding flag, IntToLongFunction encoder) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 1000; ++i) {
            int token = random.nextInt(Integer.MAX_VALUE);
            Assertions.assertNotEquals((Object)flag, (Object)RelationshipReferenceEncoding.parseEncoding((long)token));
            Assertions.assertEquals((Object)flag, (Object)RelationshipReferenceEncoding.parseEncoding((long)encoder.applyAsLong(token)));
            Assertions.assertTrue((encoder.applyAsLong(token) < 0L ? 1 : 0) != 0, (String)"encoded reference is negative");
        }
    }
}

